/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.NULLDT;
import ca.uhn.hl7v2.model.v26.datatype.OCD;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.UVC;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class UB1
extends AbstractSegment {
    public UB1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - UB1");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Blood Deductible");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood Furnished-Pints");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood Replaced-Pints");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood Not Replaced-Pints");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Co-Insurance Days");
            this.add(IS.class, false, 5, 0, new Object[]{this.getMessage(), new Integer(43)}, "Condition Code");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Covered Days");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Non Covered Days");
            this.add(UVC.class, false, 8, 0, new Object[]{this.getMessage()}, "Value Amount & Code");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Number Of Grace Days");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Special Program Indicator");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "PSRO/UR Approval Indicator");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "PSRO/UR Approved Stay-Fm");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "PSRO/UR Approved Stay-To");
            this.add(OCD.class, false, 5, 0, new Object[]{this.getMessage()}, "Occurrence");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Occurrence Span");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Occur Span Start Date");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Occur Span End Date");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UB-82 Locator 2");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UB-82 Locator 9");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UB-82 Locator 27");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UB-82 Locator 45");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating UB1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDUB1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getUb11_SetIDUB1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public NULLDT getBloodDeductible() {
        NULLDT retVal = (NULLDT)this.getTypedField(2, 0);
        return retVal;
    }

    public NULLDT getUb12_BloodDeductible() {
        NULLDT retVal = (NULLDT)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getBloodFurnishedPints() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getUb13_BloodFurnishedPints() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getBloodReplacedPints() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getUb14_BloodReplacedPints() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getBloodNotReplacedPints() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getUb15_BloodNotReplacedPints() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getCoInsuranceDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getUb16_CoInsuranceDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public IS[] getConditionCode() {
        IS[] retVal = (IS[])this.getTypedField(7, (Type[])new IS[0]);
        return retVal;
    }

    public IS[] getUb17_ConditionCode() {
        IS[] retVal = (IS[])this.getTypedField(7, (Type[])new IS[0]);
        return retVal;
    }

    public int getConditionCodeReps() {
        return this.getReps(7);
    }

    public IS getConditionCode(int rep) {
        IS retVal = (IS)this.getTypedField(7, rep);
        return retVal;
    }

    public IS getUb17_ConditionCode(int rep) {
        IS retVal = (IS)this.getTypedField(7, rep);
        return retVal;
    }

    public int getUb17_ConditionCodeReps() {
        return this.getReps(7);
    }

    public IS insertConditionCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(7, rep);
    }

    public IS insertUb17_ConditionCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(7, rep);
    }

    public IS removeConditionCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(7, rep);
    }

    public IS removeUb17_ConditionCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(7, rep);
    }

    public NM getCoveredDays() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getUb18_CoveredDays() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getNonCoveredDays() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getUb19_NonCoveredDays() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public UVC[] getValueAmountCode() {
        UVC[] retVal = (UVC[])this.getTypedField(10, (Type[])new UVC[0]);
        return retVal;
    }

    public UVC[] getUb110_ValueAmountCode() {
        UVC[] retVal = (UVC[])this.getTypedField(10, (Type[])new UVC[0]);
        return retVal;
    }

    public int getValueAmountCodeReps() {
        return this.getReps(10);
    }

    public UVC getValueAmountCode(int rep) {
        UVC retVal = (UVC)this.getTypedField(10, rep);
        return retVal;
    }

    public UVC getUb110_ValueAmountCode(int rep) {
        UVC retVal = (UVC)this.getTypedField(10, rep);
        return retVal;
    }

    public int getUb110_ValueAmountCodeReps() {
        return this.getReps(10);
    }

    public UVC insertValueAmountCode(int rep) throws HL7Exception {
        return (UVC)super.insertRepetition(10, rep);
    }

    public UVC insertUb110_ValueAmountCode(int rep) throws HL7Exception {
        return (UVC)super.insertRepetition(10, rep);
    }

    public UVC removeValueAmountCode(int rep) throws HL7Exception {
        return (UVC)super.removeRepetition(10, rep);
    }

    public UVC removeUb110_ValueAmountCode(int rep) throws HL7Exception {
        return (UVC)super.removeRepetition(10, rep);
    }

    public NM getNumberOfGraceDays() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getUb111_NumberOfGraceDays() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getSpecialProgramIndicator() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getUb112_SpecialProgramIndicator() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getPSROURApprovalIndicator() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getUb113_PSROURApprovalIndicator() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getPSROURApprovedStayFm() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getUb114_PSROURApprovedStayFm() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getPSROURApprovedStayTo() {
        DT retVal = (DT)this.getTypedField(15, 0);
        return retVal;
    }

    public DT getUb115_PSROURApprovedStayTo() {
        DT retVal = (DT)this.getTypedField(15, 0);
        return retVal;
    }

    public OCD[] getOccurrence() {
        OCD[] retVal = (OCD[])this.getTypedField(16, (Type[])new OCD[0]);
        return retVal;
    }

    public OCD[] getUb116_Occurrence() {
        OCD[] retVal = (OCD[])this.getTypedField(16, (Type[])new OCD[0]);
        return retVal;
    }

    public int getOccurrenceReps() {
        return this.getReps(16);
    }

    public OCD getOccurrence(int rep) {
        OCD retVal = (OCD)this.getTypedField(16, rep);
        return retVal;
    }

    public OCD getUb116_Occurrence(int rep) {
        OCD retVal = (OCD)this.getTypedField(16, rep);
        return retVal;
    }

    public int getUb116_OccurrenceReps() {
        return this.getReps(16);
    }

    public OCD insertOccurrence(int rep) throws HL7Exception {
        return (OCD)super.insertRepetition(16, rep);
    }

    public OCD insertUb116_Occurrence(int rep) throws HL7Exception {
        return (OCD)super.insertRepetition(16, rep);
    }

    public OCD removeOccurrence(int rep) throws HL7Exception {
        return (OCD)super.removeRepetition(16, rep);
    }

    public OCD removeUb116_Occurrence(int rep) throws HL7Exception {
        return (OCD)super.removeRepetition(16, rep);
    }

    public CWE getOccurrenceSpan() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getUb117_OccurrenceSpan() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getOccurSpanStartDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getUb118_OccurSpanStartDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getOccurSpanEndDate() {
        DT retVal = (DT)this.getTypedField(19, 0);
        return retVal;
    }

    public DT getUb119_OccurSpanEndDate() {
        DT retVal = (DT)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getUB82Locator2() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getUb120_UB82Locator2() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getUB82Locator9() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getUb121_UB82Locator9() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getUB82Locator27() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getUb122_UB82Locator27() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getUB82Locator45() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getUb123_UB82Locator45() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new NULLDT(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new IS(this.getMessage(), new Integer(43));
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new UVC(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new DT(this.getMessage());
            }
            case 15: {
                return new OCD(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new DT(this.getMessage());
            }
            case 18: {
                return new DT(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

