/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNN;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.HD;
import ca.uhn.hl7v2.model.v26.datatype.IS;

public class NDL
extends AbstractComposite {
    private Type[] data;

    public NDL(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[11];
        this.data[0] = new CNN(this.getMessage());
        this.data[1] = new DTM(this.getMessage());
        this.data[2] = new DTM(this.getMessage());
        this.data[3] = new IS(this.getMessage(), 302);
        this.data[4] = new IS(this.getMessage(), 303);
        this.data[5] = new IS(this.getMessage(), 304);
        this.data[6] = new HD(this.getMessage());
        this.data[7] = new IS(this.getMessage(), 306);
        this.data[8] = new IS(this.getMessage(), 305);
        this.data[9] = new IS(this.getMessage(), 307);
        this.data[10] = new IS(this.getMessage(), 308);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CNN getNDLName() {
        return (CNN)this.getTyped(0, CNN.class);
    }

    public CNN getNdl1_Name() {
        return (CNN)this.getTyped(0, CNN.class);
    }

    public DTM getStartDateTime() {
        return (DTM)this.getTyped(1, DTM.class);
    }

    public DTM getNdl2_StartDateTime() {
        return (DTM)this.getTyped(1, DTM.class);
    }

    public DTM getEndDateTime() {
        return (DTM)this.getTyped(2, DTM.class);
    }

    public DTM getNdl3_EndDateTime() {
        return (DTM)this.getTyped(2, DTM.class);
    }

    public IS getPointOfCare() {
        return (IS)this.getTyped(3, IS.class);
    }

    public IS getNdl4_PointOfCare() {
        return (IS)this.getTyped(3, IS.class);
    }

    public IS getRoom() {
        return (IS)this.getTyped(4, IS.class);
    }

    public IS getNdl5_Room() {
        return (IS)this.getTyped(4, IS.class);
    }

    public IS getBed() {
        return (IS)this.getTyped(5, IS.class);
    }

    public IS getNdl6_Bed() {
        return (IS)this.getTyped(5, IS.class);
    }

    public HD getFacility() {
        return (HD)this.getTyped(6, HD.class);
    }

    public HD getNdl7_Facility() {
        return (HD)this.getTyped(6, HD.class);
    }

    public IS getLocationStatus() {
        return (IS)this.getTyped(7, IS.class);
    }

    public IS getNdl8_LocationStatus() {
        return (IS)this.getTyped(7, IS.class);
    }

    public IS getPatientLocationType() {
        return (IS)this.getTyped(8, IS.class);
    }

    public IS getNdl9_PatientLocationType() {
        return (IS)this.getTyped(8, IS.class);
    }

    public IS getBuilding() {
        return (IS)this.getTyped(9, IS.class);
    }

    public IS getNdl10_Building() {
        return (IS)this.getTyped(9, IS.class);
    }

    public IS getFloor() {
        return (IS)this.getTyped(10, IS.class);
    }

    public IS getNdl11_Floor() {
        return (IS)this.getTyped(10, IS.class);
    }
}

