/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TQ;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class QRF
extends AbstractSegment {
    public QRF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 0, 20, new Object[]{this.getMessage()}, "Where Subject Filter");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "When Data Start Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "When Data End Date/Time");
            this.add(ST.class, false, 0, 60, new Object[]{this.getMessage()}, "What User Qualifier");
            this.add(ST.class, false, 0, 60, new Object[]{this.getMessage()}, "Other QRY Subject Filter");
            this.add(ID.class, false, 0, 12, new Object[]{this.getMessage(), new Integer(156)}, "Which Date/Time Qualifier");
            this.add(ID.class, false, 0, 12, new Object[]{this.getMessage(), new Integer(157)}, "Which Date/Time Status Qualifier");
            this.add(ID.class, false, 0, 12, new Object[]{this.getMessage(), new Integer(158)}, "Date/Time Selection Qualifier");
            this.add(TQ.class, false, 1, 60, new Object[]{this.getMessage()}, "When Quantity/Timing Qualifier");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "Search Confidence Threshold");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating QRF - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST[] getWhereSubjectFilter() {
        ST[] retVal = (ST[])this.getTypedField(1, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getQrf1_WhereSubjectFilter() {
        ST[] retVal = (ST[])this.getTypedField(1, (Type[])new ST[0]);
        return retVal;
    }

    public int getWhereSubjectFilterReps() {
        return this.getReps(1);
    }

    public ST getWhereSubjectFilter(int rep) {
        ST retVal = (ST)this.getTypedField(1, rep);
        return retVal;
    }

    public ST getQrf1_WhereSubjectFilter(int rep) {
        ST retVal = (ST)this.getTypedField(1, rep);
        return retVal;
    }

    public int getQrf1_WhereSubjectFilterReps() {
        return this.getReps(1);
    }

    public ST insertWhereSubjectFilter(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(1, rep);
    }

    public ST insertQrf1_WhereSubjectFilter(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(1, rep);
    }

    public ST removeWhereSubjectFilter(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(1, rep);
    }

    public ST removeQrf1_WhereSubjectFilter(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(1, rep);
    }

    public TS getWhenDataStartDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getQrf2_WhenDataStartDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getWhenDataEndDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getQrf3_WhenDataEndDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public ST[] getWhatUserQualifier() {
        ST[] retVal = (ST[])this.getTypedField(4, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getQrf4_WhatUserQualifier() {
        ST[] retVal = (ST[])this.getTypedField(4, (Type[])new ST[0]);
        return retVal;
    }

    public int getWhatUserQualifierReps() {
        return this.getReps(4);
    }

    public ST getWhatUserQualifier(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public ST getQrf4_WhatUserQualifier(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public int getQrf4_WhatUserQualifierReps() {
        return this.getReps(4);
    }

    public ST insertWhatUserQualifier(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST insertQrf4_WhatUserQualifier(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST removeWhatUserQualifier(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public ST removeQrf4_WhatUserQualifier(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public ST[] getOtherQRYSubjectFilter() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getQrf5_OtherQRYSubjectFilter() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public int getOtherQRYSubjectFilterReps() {
        return this.getReps(5);
    }

    public ST getOtherQRYSubjectFilter(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getQrf5_OtherQRYSubjectFilter(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getQrf5_OtherQRYSubjectFilterReps() {
        return this.getReps(5);
    }

    public ST insertOtherQRYSubjectFilter(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertQrf5_OtherQRYSubjectFilter(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeOtherQRYSubjectFilter(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeQrf5_OtherQRYSubjectFilter(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ID[] getWhichDateTimeQualifier() {
        ID[] retVal = (ID[])this.getTypedField(6, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getQrf6_WhichDateTimeQualifier() {
        ID[] retVal = (ID[])this.getTypedField(6, (Type[])new ID[0]);
        return retVal;
    }

    public int getWhichDateTimeQualifierReps() {
        return this.getReps(6);
    }

    public ID getWhichDateTimeQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(6, rep);
        return retVal;
    }

    public ID getQrf6_WhichDateTimeQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(6, rep);
        return retVal;
    }

    public int getQrf6_WhichDateTimeQualifierReps() {
        return this.getReps(6);
    }

    public ID insertWhichDateTimeQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(6, rep);
    }

    public ID insertQrf6_WhichDateTimeQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(6, rep);
    }

    public ID removeWhichDateTimeQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(6, rep);
    }

    public ID removeQrf6_WhichDateTimeQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(6, rep);
    }

    public ID[] getWhichDateTimeStatusQualifier() {
        ID[] retVal = (ID[])this.getTypedField(7, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getQrf7_WhichDateTimeStatusQualifier() {
        ID[] retVal = (ID[])this.getTypedField(7, (Type[])new ID[0]);
        return retVal;
    }

    public int getWhichDateTimeStatusQualifierReps() {
        return this.getReps(7);
    }

    public ID getWhichDateTimeStatusQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(7, rep);
        return retVal;
    }

    public ID getQrf7_WhichDateTimeStatusQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(7, rep);
        return retVal;
    }

    public int getQrf7_WhichDateTimeStatusQualifierReps() {
        return this.getReps(7);
    }

    public ID insertWhichDateTimeStatusQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID insertQrf7_WhichDateTimeStatusQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID removeWhichDateTimeStatusQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    public ID removeQrf7_WhichDateTimeStatusQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    public ID[] getDateTimeSelectionQualifier() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getQrf8_DateTimeSelectionQualifier() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public int getDateTimeSelectionQualifierReps() {
        return this.getReps(8);
    }

    public ID getDateTimeSelectionQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public ID getQrf8_DateTimeSelectionQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public int getQrf8_DateTimeSelectionQualifierReps() {
        return this.getReps(8);
    }

    public ID insertDateTimeSelectionQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID insertQrf8_DateTimeSelectionQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID removeDateTimeSelectionQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID removeQrf8_DateTimeSelectionQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public TQ getWhenQuantityTimingQualifier() {
        TQ retVal = (TQ)this.getTypedField(9, 0);
        return retVal;
    }

    public TQ getQrf9_WhenQuantityTimingQualifier() {
        TQ retVal = (TQ)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getSearchConfidenceThreshold() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getQrf10_SearchConfidenceThreshold() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(156));
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(157));
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(158));
            }
            case 8: {
                return new TQ(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

