/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.BAR_P02_PATIENT;
import ca.uhn.hl7v2.model.v25.segment.EVN;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class BAR_P02
extends AbstractMessage {
    public BAR_P02() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public BAR_P02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(BAR_P02_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BAR_P02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public BAR_P02_PATIENT getPATIENT() {
        return (BAR_P02_PATIENT)this.getTyped("PATIENT", BAR_P02_PATIENT.class);
    }

    public BAR_P02_PATIENT getPATIENT(int rep) {
        return (BAR_P02_PATIENT)this.getTyped("PATIENT", rep, BAR_P02_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<BAR_P02_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", BAR_P02_PATIENT.class);
    }

    public void insertPATIENT(BAR_P02_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public BAR_P02_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (BAR_P02_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public BAR_P02_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (BAR_P02_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

