/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CP;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.MO;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRC
extends AbstractSegment {
    public PRC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage()}, "Primary Key Value");
            this.add(EI.class, true, 0, 60, new Object[]{this.getMessage()}, "Facility ID");
            this.add(CE.class, false, 0, 30, new Object[]{this.getMessage()}, "Department");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(4)}, "Valid Patient Classes");
            this.add(CP.class, false, 0, 12, new Object[]{this.getMessage()}, "Price");
            this.add(ST.class, false, 0, 200, new Object[]{this.getMessage()}, "Formula");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Minimum Quantity");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Maximum Quantity");
            this.add(MO.class, false, 1, 12, new Object[]{this.getMessage()}, "Minimum Price");
            this.add(MO.class, false, 1, 12, new Object[]{this.getMessage()}, "Maximum Price");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Start Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective End Date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(268)}, "Price Override Flag");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Billing Category");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Chargeable Flag");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(183)}, "Active/Inactive Flag");
            this.add(MO.class, false, 1, 12, new Object[]{this.getMessage()}, "Cost");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(269)}, "Charge On Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getPrimaryKeyValue() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getPrc1_PrimaryKeyValue() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public EI[] getFacilityID() {
        EI[] retVal = (EI[])this.getTypedField(2, (Type[])new EI[0]);
        return retVal;
    }

    public EI[] getPrc2_FacilityID() {
        EI[] retVal = (EI[])this.getTypedField(2, (Type[])new EI[0]);
        return retVal;
    }

    public int getFacilityIDReps() {
        return this.getReps(2);
    }

    public EI getFacilityID(int rep) {
        EI retVal = (EI)this.getTypedField(2, rep);
        return retVal;
    }

    public EI getPrc2_FacilityID(int rep) {
        EI retVal = (EI)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPrc2_FacilityIDReps() {
        return this.getReps(2);
    }

    public EI insertFacilityID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(2, rep);
    }

    public EI insertPrc2_FacilityID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(2, rep);
    }

    public EI removeFacilityID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(2, rep);
    }

    public EI removePrc2_FacilityID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(2, rep);
    }

    public CE[] getDepartment() {
        CE[] retVal = (CE[])this.getTypedField(3, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getPrc3_Department() {
        CE[] retVal = (CE[])this.getTypedField(3, (Type[])new CE[0]);
        return retVal;
    }

    public int getDepartmentReps() {
        return this.getReps(3);
    }

    public CE getDepartment(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public CE getPrc3_Department(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPrc3_DepartmentReps() {
        return this.getReps(3);
    }

    public CE insertDepartment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE insertPrc3_Department(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE removeDepartment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE removePrc3_Department(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public ID[] getValidPatientClasses() {
        ID[] retVal = (ID[])this.getTypedField(4, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getPrc4_ValidPatientClasses() {
        ID[] retVal = (ID[])this.getTypedField(4, (Type[])new ID[0]);
        return retVal;
    }

    public int getValidPatientClassesReps() {
        return this.getReps(4);
    }

    public ID getValidPatientClasses(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public ID getPrc4_ValidPatientClasses(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public int getPrc4_ValidPatientClassesReps() {
        return this.getReps(4);
    }

    public ID insertValidPatientClasses(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID insertPrc4_ValidPatientClasses(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID removeValidPatientClasses(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ID removePrc4_ValidPatientClasses(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public CP[] getPrice() {
        CP[] retVal = (CP[])this.getTypedField(5, (Type[])new CP[0]);
        return retVal;
    }

    public CP[] getPrc5_Price() {
        CP[] retVal = (CP[])this.getTypedField(5, (Type[])new CP[0]);
        return retVal;
    }

    public int getPriceReps() {
        return this.getReps(5);
    }

    public CP getPrice(int rep) {
        CP retVal = (CP)this.getTypedField(5, rep);
        return retVal;
    }

    public CP getPrc5_Price(int rep) {
        CP retVal = (CP)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPrc5_PriceReps() {
        return this.getReps(5);
    }

    public CP insertPrice(int rep) throws HL7Exception {
        return (CP)super.insertRepetition(5, rep);
    }

    public CP insertPrc5_Price(int rep) throws HL7Exception {
        return (CP)super.insertRepetition(5, rep);
    }

    public CP removePrice(int rep) throws HL7Exception {
        return (CP)super.removeRepetition(5, rep);
    }

    public CP removePrc5_Price(int rep) throws HL7Exception {
        return (CP)super.removeRepetition(5, rep);
    }

    public ST[] getFormula() {
        ST[] retVal = (ST[])this.getTypedField(6, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getPrc6_Formula() {
        ST[] retVal = (ST[])this.getTypedField(6, (Type[])new ST[0]);
        return retVal;
    }

    public int getFormulaReps() {
        return this.getReps(6);
    }

    public ST getFormula(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getPrc6_Formula(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getPrc6_FormulaReps() {
        return this.getReps(6);
    }

    public ST insertFormula(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertPrc6_Formula(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeFormula(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removePrc6_Formula(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public NM getMinimumQuantity() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getPrc7_MinimumQuantity() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getMaximumQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getPrc8_MaximumQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public MO getMinimumPrice() {
        MO retVal = (MO)this.getTypedField(9, 0);
        return retVal;
    }

    public MO getPrc9_MinimumPrice() {
        MO retVal = (MO)this.getTypedField(9, 0);
        return retVal;
    }

    public MO getMaximumPrice() {
        MO retVal = (MO)this.getTypedField(10, 0);
        return retVal;
    }

    public MO getPrc10_MaximumPrice() {
        MO retVal = (MO)this.getTypedField(10, 0);
        return retVal;
    }

    public TS getEffectiveStartDate() {
        TS retVal = (TS)this.getTypedField(11, 0);
        return retVal;
    }

    public TS getPrc11_EffectiveStartDate() {
        TS retVal = (TS)this.getTypedField(11, 0);
        return retVal;
    }

    public TS getEffectiveEndDate() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getPrc12_EffectiveEndDate() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPriceOverrideFlag() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getPrc13_PriceOverrideFlag() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public CE[] getBillingCategory() {
        CE[] retVal = (CE[])this.getTypedField(14, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getPrc14_BillingCategory() {
        CE[] retVal = (CE[])this.getTypedField(14, (Type[])new CE[0]);
        return retVal;
    }

    public int getBillingCategoryReps() {
        return this.getReps(14);
    }

    public CE getBillingCategory(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public CE getPrc14_BillingCategory(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPrc14_BillingCategoryReps() {
        return this.getReps(14);
    }

    public CE insertBillingCategory(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE insertPrc14_BillingCategory(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE removeBillingCategory(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public CE removePrc14_BillingCategory(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public ID getChargeableFlag() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getPrc15_ChargeableFlag() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getPrc16_ActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public MO getCost() {
        MO retVal = (MO)this.getTypedField(17, 0);
        return retVal;
    }

    public MO getPrc17_Cost() {
        MO retVal = (MO)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getChargeOnIndicator() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getPrc18_ChargeOnIndicator() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(4));
            }
            case 4: {
                return new CP(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new MO(this.getMessage());
            }
            case 9: {
                return new MO(this.getMessage());
            }
            case 10: {
                return new TS(this.getMessage());
            }
            case 11: {
                return new TS(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(268));
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 16: {
                return new MO(this.getMessage());
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(269));
            }
        }
        return null;
    }
}

