/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RPA_I09_AUTHORIZATION;
import ca.uhn.hl7v2.model.v23.group.RPA_I09_INSURANCE;
import ca.uhn.hl7v2.model.v23.group.RPA_I09_PROCEDURE;
import ca.uhn.hl7v2.model.v23.group.RPA_I09_PROVIDER;
import ca.uhn.hl7v2.model.v23.group.RPA_I09_RESULTS;
import ca.uhn.hl7v2.model.v23.group.RPA_I09_VISIT;
import ca.uhn.hl7v2.model.v23.segment.ACC;
import ca.uhn.hl7v2.model.v23.segment.AL1;
import ca.uhn.hl7v2.model.v23.segment.DG1;
import ca.uhn.hl7v2.model.v23.segment.DRG;
import ca.uhn.hl7v2.model.v23.segment.GT1;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NK1;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.model.v23.segment.RF1;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RPA_I09
extends AbstractMessage {
    public RPA_I09() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RPA_I09(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(RF1.class, false, false);
            this.add(RPA_I09_AUTHORIZATION.class, false, false);
            this.add(RPA_I09_PROVIDER.class, true, true);
            this.add(PID.class, true, false);
            this.add(NK1.class, false, true);
            this.add(GT1.class, false, true);
            this.add(RPA_I09_INSURANCE.class, false, true);
            this.add(ACC.class, false, false);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, true);
            this.add(AL1.class, false, true);
            this.add(RPA_I09_PROCEDURE.class, true, true);
            this.add(RPA_I09_RESULTS.class, false, true);
            this.add(RPA_I09_VISIT.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPA_I09 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public RF1 getRF1() {
        return (RF1)this.getTyped("RF1", RF1.class);
    }

    public RPA_I09_AUTHORIZATION getAUTHORIZATION() {
        return (RPA_I09_AUTHORIZATION)this.getTyped("AUTHORIZATION", RPA_I09_AUTHORIZATION.class);
    }

    public RPA_I09_PROVIDER getPROVIDER() {
        return (RPA_I09_PROVIDER)this.getTyped("PROVIDER", RPA_I09_PROVIDER.class);
    }

    public RPA_I09_PROVIDER getPROVIDER(int rep) {
        return (RPA_I09_PROVIDER)this.getTyped("PROVIDER", rep, RPA_I09_PROVIDER.class);
    }

    public int getPROVIDERReps() {
        return this.getReps("PROVIDER");
    }

    public List<RPA_I09_PROVIDER> getPROVIDERAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER", RPA_I09_PROVIDER.class);
    }

    public void insertPROVIDER(RPA_I09_PROVIDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER", (Structure)structure, rep);
    }

    public RPA_I09_PROVIDER insertPROVIDER(int rep) throws HL7Exception {
        return (RPA_I09_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }

    public RPA_I09_PROVIDER removePROVIDER(int rep) throws HL7Exception {
        return (RPA_I09_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public GT1 getGT1() {
        return (GT1)this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return (GT1)this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public RPA_I09_INSURANCE getINSURANCE() {
        return (RPA_I09_INSURANCE)this.getTyped("INSURANCE", RPA_I09_INSURANCE.class);
    }

    public RPA_I09_INSURANCE getINSURANCE(int rep) {
        return (RPA_I09_INSURANCE)this.getTyped("INSURANCE", rep, RPA_I09_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<RPA_I09_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", RPA_I09_INSURANCE.class);
    }

    public void insertINSURANCE(RPA_I09_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public RPA_I09_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (RPA_I09_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public RPA_I09_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (RPA_I09_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        return (ACC)this.getTyped("ACC", ACC.class);
    }

    public DG1 getDG1() {
        return (DG1)this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return (DG1)this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return (DRG)this.getTyped("DRG", DRG.class);
    }

    public DRG getDRG(int rep) {
        return (DRG)this.getTyped("DRG", rep, DRG.class);
    }

    public int getDRGReps() {
        return this.getReps("DRG");
    }

    public List<DRG> getDRGAll() throws HL7Exception {
        return this.getAllAsList("DRG", DRG.class);
    }

    public void insertDRG(DRG structure, int rep) throws HL7Exception {
        super.insertRepetition("DRG", (Structure)structure, rep);
    }

    public DRG insertDRG(int rep) throws HL7Exception {
        return (DRG)super.insertRepetition("DRG", rep);
    }

    public DRG removeDRG(int rep) throws HL7Exception {
        return (DRG)super.removeRepetition("DRG", rep);
    }

    public AL1 getAL1() {
        return (AL1)this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return (AL1)this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public RPA_I09_PROCEDURE getPROCEDURE() {
        return (RPA_I09_PROCEDURE)this.getTyped("PROCEDURE", RPA_I09_PROCEDURE.class);
    }

    public RPA_I09_PROCEDURE getPROCEDURE(int rep) {
        return (RPA_I09_PROCEDURE)this.getTyped("PROCEDURE", rep, RPA_I09_PROCEDURE.class);
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<RPA_I09_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", RPA_I09_PROCEDURE.class);
    }

    public void insertPROCEDURE(RPA_I09_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public RPA_I09_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (RPA_I09_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public RPA_I09_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (RPA_I09_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public RPA_I09_RESULTS getRESULTS() {
        return (RPA_I09_RESULTS)this.getTyped("RESULTS", RPA_I09_RESULTS.class);
    }

    public RPA_I09_RESULTS getRESULTS(int rep) {
        return (RPA_I09_RESULTS)this.getTyped("RESULTS", rep, RPA_I09_RESULTS.class);
    }

    public int getRESULTSReps() {
        return this.getReps("RESULTS");
    }

    public List<RPA_I09_RESULTS> getRESULTSAll() throws HL7Exception {
        return this.getAllAsList("RESULTS", RPA_I09_RESULTS.class);
    }

    public void insertRESULTS(RPA_I09_RESULTS structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULTS", (Structure)structure, rep);
    }

    public RPA_I09_RESULTS insertRESULTS(int rep) throws HL7Exception {
        return (RPA_I09_RESULTS)super.insertRepetition("RESULTS", rep);
    }

    public RPA_I09_RESULTS removeRESULTS(int rep) throws HL7Exception {
        return (RPA_I09_RESULTS)super.removeRepetition("RESULTS", rep);
    }

    public RPA_I09_VISIT getVISIT() {
        return (RPA_I09_VISIT)this.getTyped("VISIT", RPA_I09_VISIT.class);
    }
}

