/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.mojo.AbstractAvroMojoTest;
import org.apache.avro.mojo.SchemaMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Test;

public class TestSchemaMojo
extends AbstractAvroMojoTest {
    private File testPom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom.xml");
    private File injectingVelocityToolsTestPom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom-injecting-velocity-tools.xml");
    private File testNonexistentFilePom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom-nonexistent-file.xml");
    private File testNonexistentSecondFilePom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom-nonexistent-second-file.xml");
    private File testExtendsFilePom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom-customExtends.xml");

    @Test
    public void testSchemaMojo() throws Exception {
        SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.testPom);
        TestSchemaMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestSchemaMojo.getBasedir(), "target/test-harness/schema/test");
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java", "SchemaUser.java", "SchemaCustom.java", "SchemaCustom.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "SchemaUser.java"));
        TestSchemaMojo.assertTrue((boolean)schemaUserContent.contains("java.time.Instant"));
    }

    @Test
    public void testSetCompilerVelocityAdditionalTools() throws Exception {
        SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.injectingVelocityToolsTestPom);
        TestSchemaMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestSchemaMojo.getBasedir(), "target/test-harness/schema-inject/test");
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java", "SchemaUser.java", "SchemaCustom.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "SchemaUser.java"));
        TestSchemaMojo.assertTrue((String)("Got " + schemaUserContent + " instead"), (boolean)schemaUserContent.contains("It works!"));
    }

    @Test
    public void testThrowsErrorForNonexistentFile() throws Exception {
        try {
            SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.testNonexistentFilePom);
            mojo.execute();
            TestSchemaMojo.fail((String)"MojoExecutionException not thrown!");
        }
        catch (MojoExecutionException mojoExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void testThrowsErrorForNonexistentSecondFile() throws Exception {
        try {
            SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.testNonexistentSecondFilePom);
            mojo.execute();
            TestSchemaMojo.fail((String)"MojoExecutionException not thrown!");
        }
        catch (MojoExecutionException mojoExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void testExtends() throws Exception {
        SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.testExtendsFilePom);
        TestSchemaMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestSchemaMojo.getBasedir(), "target/extends/schema/test");
        File outputFile = new File(outputDir, "SchemaCustom.java");
        TestSchemaMojo.assertTrue((boolean)outputFile.exists());
        List extendsLines = Files.readAllLines(outputFile.toPath()).stream().filter(line -> line.contains("class SchemaCustom extends ")).collect(Collectors.toList());
        TestSchemaMojo.assertEquals((int)1, (int)extendsLines.size());
        String extendLine = (String)extendsLines.get(0);
        TestSchemaMojo.assertTrue((boolean)extendLine.contains(" org.apache.avro.custom.CustomRecordBase "));
        TestSchemaMojo.assertFalse((boolean)extendLine.contains("org.apache.avro.specific.SpecificRecordBase"));
    }
}

