/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.avro.mojo.AbstractAvroMojoTest;
import org.apache.avro.mojo.IDLMojo;
import org.apache.avro.mojo.IDLProtocolMojo;
import org.apache.avro.mojo.TestLog;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Test;

public class TestIDLMojo
extends AbstractAvroMojoTest {
    private File testPom = new File(TestIDLMojo.getBasedir(), "src/test/resources/unit/idl/pom.xml");
    private File injectingVelocityToolsTestPom = new File(TestIDLMojo.getBasedir(), "src/test/resources/unit/idl/pom-injecting-velocity-tools.xml");
    private File incrementalCompilationTestPom = new File(TestIDLMojo.getBasedir(), "src/test/resources/unit/idl/pom-incremental-compilation.xml");

    @Test
    public void testIdlProtocolMojo() throws Exception {
        File outputDir = new File(TestIDLMojo.getBasedir(), "target/test-harness/idl/test/");
        FileUtils.deleteDirectory((File)outputDir);
        IDLMojo mojo = (IDLMojo)this.lookupMojo("idl", this.testPom);
        TestLog log = new TestLog();
        mojo.setLog((Log)log);
        TestIDLMojo.assertNotNull((Object)mojo);
        mojo.execute();
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("IdlPrivacy.java", "IdlTest.java", "IdlUser.java", "IdlUserWrapper.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String idlUserContent = FileUtils.fileRead((File)new File(outputDir, "IdlUser.java"));
        TestIDLMojo.assertTrue((boolean)idlUserContent.contains("java.time.Instant"));
        TestIDLMojo.assertEquals(Collections.singletonList("[WARN] Line 22, char 1: Ignoring out-of-place documentation comment.\nDid you mean to use a multiline comment ( /* ... */ ) instead?"), log.getLogEntries());
    }

    @Test
    public void testSetCompilerVelocityAdditionalTools() throws Exception {
        File outputDir = new File(TestIDLMojo.getBasedir(), "target/test-harness/idl-inject/test/");
        FileUtils.deleteDirectory((File)outputDir);
        IDLProtocolMojo mojo = (IDLProtocolMojo)this.lookupMojo("idl-protocol", this.injectingVelocityToolsTestPom);
        TestLog log = new TestLog();
        mojo.setLog((Log)log);
        TestIDLMojo.assertNotNull((Object)mojo);
        mojo.execute();
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("IdlPrivacy.java", "IdlTest.java", "IdlUser.java", "IdlUserWrapper.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "IdlUser.java"));
        TestIDLMojo.assertTrue((boolean)schemaUserContent.contains("It works!"));
        TestIDLMojo.assertFalse((boolean)log.getLogEntries().isEmpty());
    }

    @Test
    public void testIDLProtocolMojoSupportsIncrementalCompilation() throws Exception {
        IDLMojo mojo = (IDLMojo)this.lookupMojo("idl", this.incrementalCompilationTestPom);
        TestLog log = new TestLog();
        mojo.setLog((Log)log);
        TestIDLMojo.assertNotNull((Object)mojo);
        mojo.execute();
        Path outputDirPath = Paths.get(TestIDLMojo.getBasedir(), "target/test-harness/idl-incremental/test/");
        File outputDir = outputDirPath.toFile();
        Path idlPrivacyFilePath = outputDirPath.resolve("IdlPrivacy.java");
        FileTime idpPrivacyModificationTime = Files.getLastModifiedTime(idlPrivacyFilePath, new LinkOption[0]);
        Files.delete(idlPrivacyFilePath);
        Path idlUserFilePath = outputDirPath.resolve("IdlUser.java");
        FileTime idlUserModificationTime = Files.getLastModifiedTime(idlUserFilePath, new LinkOption[0]);
        mojo.execute();
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("IdlPrivacy.java", "IdlTest.java", "IdlUser.java", "IdlUserWrapper.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        TestIDLMojo.assertTrue((boolean)idlPrivacyFilePath.toFile().exists());
        TestIDLMojo.assertEquals((Object)Files.getLastModifiedTime(idlUserFilePath, new LinkOption[0]), (Object)idlUserModificationTime);
        TestIDLMojo.assertTrue((Files.getLastModifiedTime(idlPrivacyFilePath, new LinkOption[0]).compareTo(idpPrivacyModificationTime) > 0 ? 1 : 0) != 0);
    }
}

