/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public abstract class AbstractAvroMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File outputDirectory;
    private File testSourceDirectory;
    private File testOutputDirectory;
    private String fieldVisibility;
    protected String[] imports;
    protected String[] excludes = new String[0];
    protected String[] testExcludes = new String[0];
    protected String stringType = "CharSequence";
    protected String templateDirectory = "/org/apache/avro/compiler/specific/templates/java/classic/";
    protected String[] velocityToolsClassesNames = new String[0];
    private String recordSpecificClass = "org.apache.avro.specific.SpecificRecordBase";
    private String errorSpecificClass = "org.apache.avro.specific.SpecificExceptionBase";
    protected boolean createOptionalGetters = false;
    protected boolean gettersReturnOptional = false;
    protected boolean optionalGettersForNullableFieldsOnly = false;
    protected boolean createSetters;
    protected boolean createNullSafeAnnotations = false;
    protected String[] customConversions = new String[0];
    protected String[] customLogicalTypeFactories = new String[0];
    protected boolean enableDecimalLogicalType;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        String[] includedFiles;
        boolean hasTestDir;
        boolean hasSourceDir = null != this.sourceDirectory && this.sourceDirectory.isDirectory();
        boolean hasImports = null != this.imports;
        boolean bl = hasTestDir = null != this.testSourceDirectory && this.testSourceDirectory.isDirectory();
        if (!hasSourceDir && !hasTestDir) {
            throw new MojoExecutionException("neither sourceDirectory: " + this.sourceDirectory + " or testSourceDirectory: " + this.testSourceDirectory + " are directories");
        }
        if (hasImports) {
            this.checkImportPaths();
            for (String importedFile : this.imports) {
                File file = new File(importedFile);
                if (file.isDirectory()) {
                    Object[] includedFiles2 = this.getIncludedFiles(file.getAbsolutePath(), this.excludes, this.getIncludes());
                    this.getLog().info((CharSequence)("Importing Directory: " + file.getAbsolutePath()));
                    this.getLog().debug((CharSequence)("Importing Directory Files: " + Arrays.toString(includedFiles2)));
                    this.compileFiles((String[])includedFiles2, file, this.outputDirectory);
                    continue;
                }
                if (!file.isFile()) continue;
                this.getLog().info((CharSequence)("Importing File: " + file.getAbsolutePath()));
                this.compileFiles(new String[]{file.getName()}, file.getParentFile(), this.outputDirectory);
            }
        }
        if (hasSourceDir) {
            includedFiles = this.getIncludedFiles(this.sourceDirectory.getAbsolutePath(), this.excludes, this.getIncludes());
            this.compileFiles(includedFiles, this.sourceDirectory, this.outputDirectory);
        }
        if (hasImports || hasSourceDir) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (hasTestDir) {
            includedFiles = this.getIncludedFiles(this.testSourceDirectory.getAbsolutePath(), this.testExcludes, this.getTestIncludes());
            this.compileFiles(includedFiles, this.testSourceDirectory, this.testOutputDirectory);
            this.project.addTestCompileSourceRoot(this.testOutputDirectory.getAbsolutePath());
        }
    }

    private void checkImportPaths() throws MojoExecutionException {
        for (String importedFile : this.imports) {
            File file = new File(importedFile);
            if (file.exists()) continue;
            throw new MojoExecutionException("Path " + file.getAbsolutePath() + " does not exist");
        }
    }

    private String[] getIncludedFiles(String absPath, String[] excludes, String[] includes) {
        FileSetManager fileSetManager = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(absPath);
        fs.setFollowSymlinks(false);
        if (this.imports != null) {
            String importExclude = null;
            String[] stringArray = this.imports;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String importFile = stringArray[i];
                File file = new File(importFile);
                if (file.isDirectory()) {
                    importExclude = file.getName() + "/**";
                } else if (file.isFile()) {
                    importExclude = "**/" + file.getName();
                }
                fs.addExclude(importExclude);
            }
        }
        for (String include : includes) {
            fs.addInclude(include);
        }
        for (String exclude : excludes) {
            fs.addExclude(exclude);
        }
        return fileSetManager.getIncludedFiles(fs);
    }

    private void compileFiles(String[] files, File sourceDir, File outDir) throws MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.createClassLoader());
            try {
                this.loadLogicalTypesFactories();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while loading logical types factories ", (Exception)e);
            }
            this.doCompile(files, sourceDir, outDir);
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Cannot locate classpath entries", (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void loadLogicalTypesFactories() throws IOException, MojoExecutionException {
        try (URLClassLoader classLoader = this.createClassLoader();){
            for (String factory : this.customLogicalTypeFactories) {
                Class<?> logicalTypeFactoryClass = classLoader.loadClass(factory);
                LogicalTypes.LogicalTypeFactory factoryInstance = (LogicalTypes.LogicalTypeFactory)logicalTypeFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LogicalTypes.register((LogicalTypes.LogicalTypeFactory)factoryInstance);
            }
        }
        catch (ClassNotFoundException | DependencyResolutionRequiredException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MojoExecutionException("Failed to instantiate logical type factory class", (Exception)e);
        }
    }

    protected SpecificCompiler.FieldVisibility getFieldVisibility() {
        try {
            String upper = String.valueOf(this.fieldVisibility).trim().toUpperCase();
            return SpecificCompiler.FieldVisibility.valueOf((String)upper);
        }
        catch (IllegalArgumentException e) {
            return SpecificCompiler.FieldVisibility.PRIVATE;
        }
    }

    protected List<Object> instantiateAdditionalVelocityTools() {
        ArrayList<Object> velocityTools = new ArrayList<Object>(this.velocityToolsClassesNames.length);
        for (String velocityToolClassName : this.velocityToolsClassesNames) {
            try {
                Class<?> klass = Class.forName(velocityToolClassName);
                velocityTools.add(klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return velocityTools;
    }

    protected void doCompile(String[] files, File sourceDirectory, File outputDirectory) throws MojoExecutionException {
        for (String filename : files) {
            try {
                this.doCompile(filename, sourceDirectory, outputDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error compiling file " + filename + " to " + outputDirectory, (Exception)e);
            }
        }
    }

    protected void doCompile(String filename, File sourceDirectory, File outputDirectory) throws IOException {
        throw new UnsupportedOperationException("Programmer error: AbstractAvroMojo.doCompile(String, java.io.File, java.io.File) called directly");
    }

    protected void doCompile(File sourceFileForModificationDetection, Collection<Schema> schemas, File outputDirectory) throws IOException {
        this.doCompile(sourceFileForModificationDetection, new SpecificCompiler(schemas), outputDirectory);
    }

    protected void doCompile(File sourceFileForModificationDetection, Protocol protocol, File outputDirectory) throws IOException {
        this.doCompile(sourceFileForModificationDetection, new SpecificCompiler(protocol), outputDirectory);
    }

    private void doCompile(File sourceFileForModificationDetection, SpecificCompiler compiler, File outputDirectory) throws IOException {
        compiler.setTemplateDir(this.templateDirectory);
        compiler.setStringType(GenericData.StringType.valueOf((String)this.stringType));
        compiler.setFieldVisibility(this.getFieldVisibility());
        compiler.setCreateOptionalGetters(this.createOptionalGetters);
        compiler.setGettersReturnOptional(this.gettersReturnOptional);
        compiler.setOptionalGettersForNullableFieldsOnly(this.optionalGettersForNullableFieldsOnly);
        compiler.setCreateSetters(this.createSetters);
        compiler.setCreateNullSafeAnnotations(this.createNullSafeAnnotations);
        compiler.setEnableDecimalLogicalType(this.enableDecimalLogicalType);
        try {
            for (String customConversion : this.customConversions) {
                compiler.addCustomConversion(Thread.currentThread().getContextClassLoader().loadClass(customConversion));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        compiler.setOutputCharacterEncoding(this.project.getProperties().getProperty("project.build.sourceEncoding"));
        compiler.setAdditionalVelocityTools(this.instantiateAdditionalVelocityTools());
        compiler.setRecordSpecificClass(this.recordSpecificClass);
        compiler.setErrorSpecificClass(this.errorSpecificClass);
        compiler.compileToDestination(sourceFileForModificationDetection, outputDirectory);
    }

    protected List<URL> findClasspath() throws DependencyResolutionRequiredException, MalformedURLException {
        List<URL> urls = this.appendElements(this.project.getRuntimeClasspathElements());
        urls.addAll(this.appendElements(this.project.getTestClasspathElements()));
        return urls;
    }

    protected URLClassLoader createClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        List<URL> urls = this.findClasspath();
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    private List<URL> appendElements(List<String> runtimeClasspathElements) throws MalformedURLException {
        if (runtimeClasspathElements == null) {
            return new ArrayList<URL>();
        }
        ArrayList<URL> runtimeUrls = new ArrayList<URL>(runtimeClasspathElements.size());
        for (String runtimeClasspathElement : runtimeClasspathElements) {
            runtimeUrls.add(new File(runtimeClasspathElement).toURI().toURL());
        }
        return runtimeUrls;
    }

    protected abstract String[] getIncludes();

    protected abstract String[] getTestIncludes();
}

