/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.avro.mojo.AbstractAvroMojoTest;
import org.apache.avro.mojo.ProtocolMojo;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Test;

public class TestProtocolMojo
extends AbstractAvroMojoTest {
    private File testPom = new File(TestProtocolMojo.getBasedir(), "src/test/resources/unit/protocol/pom.xml");
    private File injectingVelocityToolsTestPom = new File(TestProtocolMojo.getBasedir(), "src/test/resources/unit/protocol/pom-injecting-velocity-tools.xml");

    @Test
    public void testProtocolMojo() throws Exception {
        ProtocolMojo mojo = (ProtocolMojo)this.lookupMojo("protocol", this.testPom);
        TestProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestProtocolMojo.getBasedir(), "target/test-harness/protocol/test");
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("ProtocolPrivacy.java", "ProtocolTest.java", "ProtocolUser.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String protocolUserContent = FileUtils.fileRead((File)new File(outputDir, "ProtocolUser.java"));
        TestProtocolMojo.assertTrue((String)("Got " + protocolUserContent + " instead"), (boolean)protocolUserContent.contains("java.time.Instant"));
    }

    @Test
    public void testSetCompilerVelocityAdditionalTools() throws Exception {
        ProtocolMojo mojo = (ProtocolMojo)this.lookupMojo("protocol", this.injectingVelocityToolsTestPom);
        TestProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestProtocolMojo.getBasedir(), "target/test-harness/protocol-inject/test");
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("ProtocolPrivacy.java", "ProtocolTest.java", "ProtocolUser.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "ProtocolUser.java"));
        TestProtocolMojo.assertTrue((boolean)schemaUserContent.contains("It works!"));
    }
}

