/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import software.amazon.s3.shaded.dev.failsafe.ExecutionContext;
import software.amazon.s3.shaded.dev.failsafe.FallbackConfig;
import software.amazon.s3.shaded.dev.failsafe.internal.EventHandler;
import software.amazon.s3.shaded.dev.failsafe.internal.FallbackImpl;
import software.amazon.s3.shaded.dev.failsafe.spi.AsyncExecutionInternal;
import software.amazon.s3.shaded.dev.failsafe.spi.ExecutionResult;
import software.amazon.s3.shaded.dev.failsafe.spi.FailsafeFuture;
import software.amazon.s3.shaded.dev.failsafe.spi.PolicyExecutor;
import software.amazon.s3.shaded.dev.failsafe.spi.Scheduler;
import software.amazon.s3.shaded.dev.failsafe.spi.SyncExecutionInternal;

public class FallbackExecutor<R>
extends PolicyExecutor<R> {
    private final FallbackImpl<R> fallback;
    private final FallbackConfig<R> config;
    private final EventHandler<R> failedAttemptHandler;

    public FallbackExecutor(FallbackImpl<R> fallback, int policyIndex) {
        super(fallback, policyIndex);
        this.fallback = fallback;
        this.config = fallback.getConfig();
        this.failedAttemptHandler = EventHandler.ofExecutionAttempted(this.config.getFailedAttemptListener());
    }

    @Override
    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn, Scheduler scheduler) {
        return execution -> {
            ExecutionResult<R> result = (ExecutionResult<R>)innerFn.apply((SyncExecutionInternal<R>)execution);
            if (execution.isCancelled(this)) {
                return result;
            }
            if (this.isFailure(result)) {
                if (this.failedAttemptHandler != null) {
                    this.failedAttemptHandler.handle(result, (ExecutionContext<R>)execution);
                }
                try {
                    result = this.fallback == FallbackImpl.NONE ? result.withNonResult() : result.withResult(this.fallback.apply(result.getResult(), result.getException(), execution));
                }
                catch (Throwable t) {
                    result = ExecutionResult.exception(t);
                }
            }
            return this.postExecute(execution, result);
        };
    }

    @Override
    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        return execution -> ((CompletableFuture)innerFn.apply((AsyncExecutionInternal<R>)execution)).thenCompose(result -> {
            if (result == null || future.isDone()) {
                return ExecutionResult.nullFuture();
            }
            if (execution.isCancelled(this)) {
                return CompletableFuture.completedFuture(result);
            }
            if (!this.isFailure(result)) {
                return this.postExecuteAsync(execution, result, scheduler, future);
            }
            if (this.failedAttemptHandler != null) {
                this.failedAttemptHandler.handle((ExecutionResult<R>)result, (ExecutionContext<R>)execution);
            }
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> {
                try {
                    CompletableFuture<R> fallbackFuture = this.fallback.applyStage(result.getResult(), result.getException(), execution);
                    fallbackFuture.whenComplete((innerResult, exception) -> {
                        if (exception instanceof CompletionException) {
                            exception = exception.getCause();
                        }
                        ExecutionResult<Object> r = exception == null ? result.withResult(innerResult) : ExecutionResult.exception(exception);
                        promise.complete(r);
                    });
                }
                catch (Throwable t) {
                    promise.complete(ExecutionResult.exception(t));
                }
                return null;
            };
            try {
                if (!this.config.isAsync()) {
                    callable.call();
                } else {
                    ScheduledFuture<?> scheduledFallback = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                    future.setCancelFn(this, (mayInterrupt, cancelResult) -> {
                        scheduledFallback.cancel((boolean)mayInterrupt);
                        promise.complete(cancelResult);
                    });
                }
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return promise.thenCompose(ss -> this.postExecuteAsync(execution, ss, scheduler, future));
        });
    }
}

