/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe;

import java.time.Duration;
import software.amazon.s3.shaded.dev.failsafe.CircuitBreakerBuilder;
import software.amazon.s3.shaded.dev.failsafe.CircuitBreakerConfig;
import software.amazon.s3.shaded.dev.failsafe.CircuitBreakerOpenException;
import software.amazon.s3.shaded.dev.failsafe.Policy;

public interface CircuitBreaker<R>
extends Policy<R> {
    public static <R> CircuitBreakerBuilder<R> builder() {
        return new CircuitBreakerBuilder();
    }

    public static <R> CircuitBreakerBuilder<R> builder(CircuitBreakerConfig<R> config) {
        return new CircuitBreakerBuilder<R>(config);
    }

    public static <R> CircuitBreaker<R> ofDefaults() {
        return CircuitBreaker.builder().build();
    }

    @Override
    public CircuitBreakerConfig<R> getConfig();

    default public void acquirePermit() {
        if (!this.tryAcquirePermit()) {
            throw new CircuitBreakerOpenException(this);
        }
    }

    public boolean tryAcquirePermit();

    public void open();

    public void close();

    public void halfOpen();

    public State getState();

    public int getExecutionCount();

    public Duration getRemainingDelay();

    public long getFailureCount();

    public int getFailureRate();

    public int getSuccessCount();

    public int getSuccessRate();

    public boolean isClosed();

    public boolean isHalfOpen();

    public boolean isOpen();

    public void recordFailure();

    public void recordException(Throwable var1);

    public void recordResult(R var1);

    public void recordSuccess();

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

