/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.AllowedHeadersCopier;
import software.amazon.awssdk.services.s3.model.AllowedMethodsCopier;
import software.amazon.awssdk.services.s3.model.AllowedOriginsCopier;
import software.amazon.awssdk.services.s3.model.ExposeHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CORSRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CORSRule> {
    private static final SdkField<List<String>> ALLOWED_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CORSRule.getter(CORSRule::allowedHeaders)).setter(CORSRule.setter(Builder::allowedHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedHeader").unmarshallLocationName("AllowedHeader").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<List<String>> ALLOWED_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CORSRule.getter(CORSRule::allowedMethods)).setter(CORSRule.setter(Builder::allowedMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMethod").unmarshallLocationName("AllowedMethod").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<List<String>> ALLOWED_ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CORSRule.getter(CORSRule::allowedOrigins)).setter(CORSRule.setter(Builder::allowedOrigins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOrigin").unmarshallLocationName("AllowedOrigin").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<List<String>> EXPOSE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CORSRule.getter(CORSRule::exposeHeaders)).setter(CORSRule.setter(Builder::exposeHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExposeHeader").unmarshallLocationName("ExposeHeader").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<Integer> MAX_AGE_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CORSRule.getter(CORSRule::maxAgeSeconds)).setter(CORSRule.setter(Builder::maxAgeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAgeSeconds").unmarshallLocationName("MaxAgeSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_HEADERS_FIELD, ALLOWED_METHODS_FIELD, ALLOWED_ORIGINS_FIELD, EXPOSE_HEADERS_FIELD, MAX_AGE_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedHeaders;
    private final List<String> allowedMethods;
    private final List<String> allowedOrigins;
    private final List<String> exposeHeaders;
    private final Integer maxAgeSeconds;

    private CORSRule(BuilderImpl builder) {
        this.allowedHeaders = builder.allowedHeaders;
        this.allowedMethods = builder.allowedMethods;
        this.allowedOrigins = builder.allowedOrigins;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAgeSeconds = builder.maxAgeSeconds;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public Integer maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedMethods());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOrigins());
        hashCode = 31 * hashCode + Objects.hashCode(this.exposeHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAgeSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CORSRule)) {
            return false;
        }
        CORSRule other = (CORSRule)obj;
        return Objects.equals(this.allowedHeaders(), other.allowedHeaders()) && Objects.equals(this.allowedMethods(), other.allowedMethods()) && Objects.equals(this.allowedOrigins(), other.allowedOrigins()) && Objects.equals(this.exposeHeaders(), other.exposeHeaders()) && Objects.equals(this.maxAgeSeconds(), other.maxAgeSeconds());
    }

    public String toString() {
        return ToString.builder((String)"CORSRule").add("AllowedHeaders", this.allowedHeaders()).add("AllowedMethods", this.allowedMethods()).add("AllowedOrigins", this.allowedOrigins()).add("ExposeHeaders", this.exposeHeaders()).add("MaxAgeSeconds", (Object)this.maxAgeSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedHeaders": {
                return Optional.ofNullable(clazz.cast(this.allowedHeaders()));
            }
            case "AllowedMethods": {
                return Optional.ofNullable(clazz.cast(this.allowedMethods()));
            }
            case "AllowedOrigins": {
                return Optional.ofNullable(clazz.cast(this.allowedOrigins()));
            }
            case "ExposeHeaders": {
                return Optional.ofNullable(clazz.cast(this.exposeHeaders()));
            }
            case "MaxAgeSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxAgeSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CORSRule, T> g) {
        return obj -> g.apply((CORSRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedHeaders = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedMethods = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedOrigins = DefaultSdkAutoConstructList.getInstance();
        private List<String> exposeHeaders = DefaultSdkAutoConstructList.getInstance();
        private Integer maxAgeSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CORSRule model) {
            this.allowedHeaders(model.allowedHeaders);
            this.allowedMethods(model.allowedMethods);
            this.allowedOrigins(model.allowedOrigins);
            this.exposeHeaders(model.exposeHeaders);
            this.maxAgeSeconds(model.maxAgeSeconds);
        }

        public final Collection<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Override
        public final Builder allowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedHeaders(String ... allowedHeaders) {
            this.allowedHeaders(Arrays.asList(allowedHeaders));
            return this;
        }

        public final void setAllowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
        }

        public final Collection<String> getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final Builder allowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMethods(String ... allowedMethods) {
            this.allowedMethods(Arrays.asList(allowedMethods));
            return this;
        }

        public final void setAllowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
        }

        public final Collection<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Override
        public final Builder allowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrigins(String ... allowedOrigins) {
            this.allowedOrigins(Arrays.asList(allowedOrigins));
            return this;
        }

        public final void setAllowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
        }

        public final Collection<String> getExposeHeaders() {
            return this.exposeHeaders;
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String ... exposeHeaders) {
            this.exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
        }

        public final Integer getMaxAgeSeconds() {
            return this.maxAgeSeconds;
        }

        @Override
        public final Builder maxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public final void setMaxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
        }

        public CORSRule build() {
            return new CORSRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CORSRule> {
        public Builder allowedHeaders(Collection<String> var1);

        public Builder allowedHeaders(String ... var1);

        public Builder allowedMethods(Collection<String> var1);

        public Builder allowedMethods(String ... var1);

        public Builder allowedOrigins(Collection<String> var1);

        public Builder allowedOrigins(String ... var1);

        public Builder exposeHeaders(Collection<String> var1);

        public Builder exposeHeaders(String ... var1);

        public Builder maxAgeSeconds(Integer var1);
    }
}

