/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse;

public class ListContributorInsightsIterable
implements SdkIterable<ListContributorInsightsResponse> {
    private final DynamoDbClient client;
    private final ListContributorInsightsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContributorInsightsIterable(DynamoDbClient client, ListContributorInsightsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListContributorInsightsResponseFetcher();
    }

    public Iterator<ListContributorInsightsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListContributorInsightsResponseFetcher
    implements SyncPageFetcher<ListContributorInsightsResponse> {
        private ListContributorInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListContributorInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContributorInsightsResponse nextPage(ListContributorInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListContributorInsightsIterable.this.client.listContributorInsights(ListContributorInsightsIterable.this.firstRequest);
            }
            return ListContributorInsightsIterable.this.client.listContributorInsights((ListContributorInsightsRequest)((Object)ListContributorInsightsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

