/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A uniquely identified group of stream records within a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Shard implements SdkPojo, Serializable, ToCopyableBuilder<Shard.Builder, Shard> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShardId").getter(getter(Shard::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();

    private static final SdkField<SequenceNumberRange> SEQUENCE_NUMBER_RANGE_FIELD = SdkField
            .<SequenceNumberRange> builder(MarshallingType.SDK_POJO).memberName("SequenceNumberRange")
            .getter(getter(Shard::sequenceNumberRange)).setter(setter(Builder::sequenceNumberRange))
            .constructor(SequenceNumberRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumberRange").build())
            .build();

    private static final SdkField<String> PARENT_SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentShardId").getter(getter(Shard::parentShardId)).setter(setter(Builder::parentShardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentShardId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD,
            SEQUENCE_NUMBER_RANGE_FIELD, PARENT_SHARD_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String shardId;

    private final SequenceNumberRange sequenceNumberRange;

    private final String parentShardId;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.sequenceNumberRange = builder.sequenceNumberRange;
        this.parentShardId = builder.parentShardId;
    }

    /**
     * <p>
     * The system-generated identifier for this shard.
     * </p>
     * 
     * @return The system-generated identifier for this shard.
     */
    public final String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The range of possible sequence numbers for the shard.
     * </p>
     * 
     * @return The range of possible sequence numbers for the shard.
     */
    public final SequenceNumberRange sequenceNumberRange() {
        return sequenceNumberRange;
    }

    /**
     * <p>
     * The shard ID of the current shard's parent.
     * </p>
     * 
     * @return The shard ID of the current shard's parent.
     */
    public final String parentShardId() {
        return parentShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumberRange());
        hashCode = 31 * hashCode + Objects.hashCode(parentShardId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard) obj;
        return Objects.equals(shardId(), other.shardId()) && Objects.equals(sequenceNumberRange(), other.sequenceNumberRange())
                && Objects.equals(parentShardId(), other.parentShardId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Shard").add("ShardId", shardId()).add("SequenceNumberRange", sequenceNumberRange())
                .add("ParentShardId", parentShardId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        case "SequenceNumberRange":
            return Optional.ofNullable(clazz.cast(sequenceNumberRange()));
        case "ParentShardId":
            return Optional.ofNullable(clazz.cast(parentShardId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Shard, T> g) {
        return obj -> g.apply((Shard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Shard> {
        /**
         * <p>
         * The system-generated identifier for this shard.
         * </p>
         * 
         * @param shardId
         *        The system-generated identifier for this shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The range of possible sequence numbers for the shard.
         * </p>
         * 
         * @param sequenceNumberRange
         *        The range of possible sequence numbers for the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange);

        /**
         * <p>
         * The range of possible sequence numbers for the shard.
         * </p>
         * This is a convenience method that creates an instance of the {@link SequenceNumberRange.Builder} avoiding the
         * need to create one manually via {@link SequenceNumberRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SequenceNumberRange.Builder#build()} is called immediately and
         * its result is passed to {@link #sequenceNumberRange(SequenceNumberRange)}.
         * 
         * @param sequenceNumberRange
         *        a consumer that will call methods on {@link SequenceNumberRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sequenceNumberRange(SequenceNumberRange)
         */
        default Builder sequenceNumberRange(Consumer<SequenceNumberRange.Builder> sequenceNumberRange) {
            return sequenceNumberRange(SequenceNumberRange.builder().applyMutation(sequenceNumberRange).build());
        }

        /**
         * <p>
         * The shard ID of the current shard's parent.
         * </p>
         * 
         * @param parentShardId
         *        The shard ID of the current shard's parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentShardId(String parentShardId);
    }

    static final class BuilderImpl implements Builder {
        private String shardId;

        private SequenceNumberRange sequenceNumberRange;

        private String parentShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            shardId(model.shardId);
            sequenceNumberRange(model.sequenceNumberRange);
            parentShardId(model.parentShardId);
        }

        public final String getShardId() {
            return shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return sequenceNumberRange != null ? sequenceNumberRange.toBuilder() : null;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final String getParentShardId() {
            return parentShardId;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        @Override
        public Shard build() {
            return new Shard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
