/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.output.NullWriter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.js.JsLintProcessor;
import ro.isdc.wro.extensions.processor.support.linter.LinterError;
import ro.isdc.wro.extensions.processor.support.linter.LinterException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractLinterMojo;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@Mojo(name="jslint", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JsLintMojo
extends AbstractLinterMojo<LinterError> {
    private File reportFile;
    private String reportFormat = ReportXmlFormatter.FormatterType.JSLINT.getFormat();

    @Override
    protected ResourcePreProcessor createResourceProcessor() {
        return new JsLintProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                JsLintMojo.this.getProgressIndicator().onProcessingResource(resource);
                if (resource != null) {
                    JsLintMojo.this.getLog().info((CharSequence)("processing resource: " + resource.getUri()));
                }
                super.process(resource, reader, (Writer)new NullWriter());
            }

            protected void onException(WroRuntimeException e) {
                JsLintMojo.this.onException((Exception)e);
            }

            protected void onLinterException(LinterException e, Resource resource) {
                String errorMessage = String.format("%s errors found while processing resource: %s. Errors are: %s", e.getErrors().size(), resource, e.getErrors());
                JsLintMojo.this.getProgressIndicator().addFoundErrors(e.getErrors().size());
                JsLintMojo.this.getLog().error((CharSequence)errorMessage);
                JsLintMojo.this.addReport(ResourceLintReport.create((String)resource.getUri(), (Collection)e.getErrors()));
                if (JsLintMojo.this.isFailAllowed()) {
                    throw e;
                }
            }
        }.setOptionsAsString(this.getOptions());
    }

    @Override
    protected boolean wantProcessGroup(String groupName, ResourceType resourceType) {
        return resourceType == ResourceType.JS;
    }

    @Override
    protected ReportXmlFormatter createXmlFormatter(LintReport<LinterError> lintReport, ReportXmlFormatter.FormatterType type) {
        return ReportXmlFormatter.createForLinterError(lintReport, (ReportXmlFormatter.FormatterType)type);
    }

    @Override
    protected File getReportFile() {
        return this.reportFile;
    }

    @Override
    protected String getReportFormat() {
        return this.reportFormat;
    }

    void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    @Override
    void onException(Exception e) {
    }
}

