/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.output.NullWriter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.css.CssLintProcessor;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintError;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractLinterMojo;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@Mojo(name="csslint", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CssLintMojo
extends AbstractLinterMojo<CssLintError> {
    private File reportFile;
    private String reportFormat = ReportXmlFormatter.FormatterType.LINT.getFormat();

    @Override
    protected ResourcePreProcessor createResourceProcessor() {
        return new CssLintProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                CssLintMojo.this.getProgressIndicator().onProcessingResource(resource);
                super.process(resource, reader, (Writer)new NullWriter());
            }

            protected void onException(WroRuntimeException e) {
                CssLintMojo.this.onException((Exception)e);
            }

            protected void onCssLintException(CssLintException e, Resource resource) {
                CssLintMojo.this.getProgressIndicator().addFoundErrors(e.getErrors().size());
                CssLintMojo.this.getLog().error((CharSequence)(e.getErrors().size() + " errors found while processing resource: " + resource.getUri() + " Errors are: " + e.getErrors()));
                CssLintMojo.this.addReport(ResourceLintReport.create((String)resource.getUri(), (Collection)e.getErrors()));
                if (CssLintMojo.this.isFailAllowed()) {
                    throw e;
                }
            }
        }.setOptionsAsString(this.getOptions());
    }

    @Override
    protected boolean wantProcessGroup(String groupName, ResourceType resourceType) {
        return resourceType == ResourceType.CSS;
    }

    @Override
    protected ReportXmlFormatter createXmlFormatter(LintReport<CssLintError> lintReport, ReportXmlFormatter.FormatterType type) {
        return ReportXmlFormatter.createForCssLintError(lintReport, (ReportXmlFormatter.FormatterType)type);
    }

    @Override
    protected File getReportFile() {
        return this.reportFile;
    }

    @Override
    protected String getReportFormat() {
        return this.reportFormat;
    }

    void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    @Override
    void onException(Exception e) {
    }
}

