import { hasProperty } from '../../../util';
import { VG_MARK_CONFIGS } from '../../../vega.schema';
import { signalOrValueRef } from '../../common';
import { aria } from './aria';
import { color } from './color';
import { nonPosition } from './nonposition';
import { text } from './text';
import { tooltip } from './tooltip';
import { zindex } from './zindex';
export { color } from './color';
export { nonPosition } from './nonposition';
export { pointPosition } from './position-point';
export { pointOrRangePosition, rangePosition } from './position-range';
export { rectPosition } from './position-rect';
export { text } from './text';
export { tooltip } from './tooltip';
const ALWAYS_IGNORE = new Set(['aria', 'width', 'height']);
export function baseEncodeEntry(model, ignore) {
    const { fill = undefined, stroke = undefined } = ignore.color === 'include' ? color(model) : {};
    return {
        ...markDefProperties(model.markDef, ignore),
        ...colorRef('fill', fill),
        ...colorRef('stroke', stroke),
        ...nonPosition('opacity', model),
        ...nonPosition('fillOpacity', model),
        ...nonPosition('strokeOpacity', model),
        ...nonPosition('strokeWidth', model),
        ...nonPosition('strokeDash', model),
        ...zindex(model),
        ...tooltip(model),
        ...text(model, 'href'),
        ...aria(model)
    };
}
function colorRef(channel, valueRef) {
    return valueRef ? { [channel]: valueRef } : {};
}
function markDefProperties(mark, ignore) {
    return VG_MARK_CONFIGS.reduce((m, prop) => {
        if (!ALWAYS_IGNORE.has(prop) && hasProperty(mark, prop) && ignore[prop] !== 'ignore') {
            m[prop] = signalOrValueRef(mark[prop]);
        }
        return m;
    }, {});
}
//# sourceMappingURL=base.js.map