/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxCreatorInformation;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.maven.Annotation;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.utils.LicenseManager;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxDependencyInformation;
import org.spdx.maven.utils.SpdxExternalRefBuilder;
import org.spdx.maven.utils.SpdxFileCollector;
import org.spdx.maven.utils.SpdxProjectInformation;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SpdxDocumentBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SpdxDocumentBuilder.class);
    private static final String UNSPECIFIED = "UNSPECIFIED";
    public static final String NULL_SHA1 = "cf23df2207d99a74fbe169e3eba035e633b65d94";
    DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private MavenProject project;
    private boolean generatePurls;
    private SpdxDocument spdxDoc;
    private SpdxPackage projectPackage;
    private LicenseManager licenseManager;
    private File spdxFile;
    private ISerializableModelStore modelStore;
    private ModelCopyManager copyManager;

    public SpdxDocumentBuilder(MavenProject project, boolean generatePurls, File spdxFile, URI spdxDocumentNamespace, boolean useStdLicenseSourceUrls, OutputFormat outputFormat) throws SpdxBuilderException, LicenseMapperException {
        this.project = project;
        this.generatePurls = generatePurls;
        this.spdxFile = spdxFile;
        if (spdxDocumentNamespace == null) {
            throw new SpdxBuilderException("Missing spdxDocumentNamespace");
        }
        if (!spdxFile.exists()) {
            File parentDir = spdxFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                throw new SpdxBuilderException("Unable to create directories for SPDX file");
            }
            try {
                if (!spdxFile.createNewFile()) {
                    throw new SpdxBuilderException("Unable to create the SPDX file");
                }
            }
            catch (IOException e) {
                throw new SpdxBuilderException("IO error creating the SPDX file", e);
            }
        }
        if (!spdxFile.canWrite()) {
            throw new SpdxBuilderException("Unable to write to SPDX file - check permissions: " + spdxFile.getPath());
        }
        try {
            this.modelStore = outputFormat == OutputFormat.RDF_XML ? new RdfStore() : new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY);
            this.copyManager = new ModelCopyManager();
            this.spdxDoc = SpdxModelFactory.createSpdxDocument((IModelStore)this.modelStore, (String)spdxDocumentNamespace.toString(), (ModelCopyManager)this.copyManager);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error creating SPDX document", e);
        }
        this.licenseManager = new LicenseManager(this.spdxDoc, useStdLicenseSourceUrls);
    }

    public void addNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) throws SpdxBuilderException {
        if (nonStandardLicenses != null) {
            for (NonStandardLicense nonStandardLicense : nonStandardLicenses) {
                try {
                    this.licenseManager.addExtractedLicense(nonStandardLicense);
                }
                catch (LicenseManagerException e) {
                    throw new SpdxBuilderException("Error adding non standard license", e);
                }
            }
        }
    }

    public SpdxDocument getSpdxDoc() {
        return this.spdxDoc;
    }

    public void saveSpdxDocumentToFile() throws SpdxBuilderException {
        try (FileOutputStream spdxOut = new FileOutputStream(this.spdxFile);){
            this.modelStore.serialize(this.spdxDoc.getDocumentUri(), (OutputStream)spdxOut);
        }
        catch (FileNotFoundException e) {
            throw new SpdxBuilderException("Error saving SPDX data to file", e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error collecting SPDX file data", e);
        }
        catch (IOException e) {
            throw new SpdxBuilderException("I/O Error saving SPDX data to file", e);
        }
    }

    public void addDependencyInformation(SpdxDependencyInformation dependencyInformation) throws SpdxBuilderException {
        Map<SpdxElement, List<Relationship>> packageRelationships = dependencyInformation.getRelationships();
        if (packageRelationships != null) {
            for (Map.Entry<SpdxElement, List<Relationship>> entry : packageRelationships.entrySet()) {
                SpdxElement parentElement = entry.getKey();
                List<Relationship> relationships = entry.getValue();
                for (Relationship relationship : relationships) {
                    try {
                        parentElement.addRelationship(relationship);
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        throw new SpdxBuilderException("Unable to set package dependencies", e);
                    }
                }
            }
        }
    }

    public void fillSpdxDocumentInformation(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        try {
            if (projectInformation.getDocumentComment() != null && !projectInformation.getDocumentComment().isEmpty()) {
                this.spdxDoc.setComment(projectInformation.getDocumentComment());
            }
            this.fillCreatorInfo(projectInformation);
            SpdxListedLicense dataLicense = LicenseInfoFactory.getListedLicenseById((String)"CC0-1.0");
            this.spdxDoc.setDataLicense((AnyLicenseInfo)dataLicense);
            if (projectInformation.getDocumentAnnotations() != null && projectInformation.getDocumentAnnotations().length > 0) {
                this.spdxDoc.setAnnotations(this.toSpdxAnnotations(projectInformation.getDocumentAnnotations()));
            }
            this.spdxDoc.setName(projectInformation.getName());
            this.projectPackage = this.createSpdxPackage(projectInformation);
            Relationship documentContainsRelationship = this.spdxDoc.createRelationship((SpdxElement)this.projectPackage, RelationshipType.DESCRIBES, "");
            this.spdxDoc.addRelationship(documentContainsRelationship);
        }
        catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error adding package information to SPDX document", e);
        }
    }

    private Collection<org.spdx.library.model.Annotation> toSpdxAnnotations(Annotation[] annotations) throws MojoExecutionException {
        ArrayList<org.spdx.library.model.Annotation> retval = new ArrayList<org.spdx.library.model.Annotation>();
        for (Annotation annotation : annotations) {
            retval.add(annotation.toSpdxAnnotation(this.spdxDoc));
        }
        return retval;
    }

    private SpdxPackage createSpdxPackage(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        ExternalReference[] externalRefs;
        SpdxPackage pkg;
        SpdxPackageVerificationCode nullPackageVerificationCode;
        String copyrightText = projectInformation.getCopyrightText();
        if (copyrightText == null) {
            copyrightText = UNSPECIFIED;
        }
        String downloadUrl = null;
        if (SpdxVerificationHelper.isValidUri((String)projectInformation.getDownloadUrl())) {
            downloadUrl = projectInformation.getDownloadUrl();
        } else {
            LOG.warn("Invalid download location in POM file: " + projectInformation.getDownloadUrl());
        }
        if (downloadUrl == null) {
            downloadUrl = UNSPECIFIED;
        }
        try {
            nullPackageVerificationCode = this.spdxDoc.createPackageVerificationCode(NULL_SHA1, new ArrayList());
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error creating null package verification code", e);
        }
        try {
            pkg = this.spdxDoc.createPackage(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.spdxDoc.getDocumentUri()), projectInformation.getName(), projectInformation.getConcludedLicense(), copyrightText, projectInformation.getDeclaredLicense()).setDownloadLocation(downloadUrl).setPackageVerificationCode(nullPackageVerificationCode).setPrimaryPurpose(projectInformation.getPrimaryPurpose()).setExternalRefs(SpdxExternalRefBuilder.getDefaultExternalRefs(this.spdxDoc, this.generatePurls, this.project)).build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error creating initial package", e);
        }
        if (projectInformation.getPackageAnnotations() != null && projectInformation.getPackageAnnotations().length > 0) {
            try {
                pkg.setAnnotations(this.toSpdxAnnotations(projectInformation.getPackageAnnotations()));
            }
            catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
                throw new SpdxBuilderException("Error adding package annotations to SPDX document", e);
            }
        }
        try {
            if (projectInformation.getDescription() != null) {
                pkg.setDescription(projectInformation.getDescription());
            }
            if (projectInformation.getDownloadUrl() != null) {
                pkg.setDownloadLocation(projectInformation.getDownloadUrl());
            }
            if (projectInformation.getPackageArchiveFileName() != null) {
                pkg.setPackageFileName(projectInformation.getPackageArchiveFileName());
            }
            if (projectInformation.getHomePage() != null) {
                try {
                    pkg.setHomepage(projectInformation.getHomePage());
                }
                catch (InvalidSPDXAnalysisException ex) {
                    LOG.warn("Invalid URL in project POM file: " + projectInformation.getHomePage());
                }
            }
            if (projectInformation.getSourceInfo() != null) {
                pkg.setSourceInfo(projectInformation.getSourceInfo());
            }
            if (projectInformation.getLicenseComment() != null) {
                pkg.setLicenseComments(projectInformation.getLicenseComment());
            }
            if (projectInformation.getOriginator() != null) {
                pkg.setOriginator(projectInformation.getOriginator());
            }
            if (projectInformation.getShortDescription() != null) {
                pkg.setSummary(projectInformation.getShortDescription());
            }
            if (projectInformation.getSupplier() != null) {
                pkg.setSupplier(projectInformation.getSupplier());
            }
            if (projectInformation.getVersionInfo() != null) {
                pkg.setVersionInfo(projectInformation.getVersionInfo());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error adding package properties", e);
        }
        if (projectInformation.getChecksums() != null) {
            try {
                pkg.getChecksums().addAll(projectInformation.getChecksums());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid checksum provided", e);
            }
        }
        if ((externalRefs = projectInformation.getExternalRefs()) != null && externalRefs.length > 0) {
            for (ExternalReference externalRef : externalRefs) {
                try {
                    pkg.getExternalRefs().add(externalRef.getExternalRef(this.spdxDoc));
                }
                catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
                    throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid external refs provided", e);
                }
            }
        }
        return pkg;
    }

    private void fillCreatorInfo(SpdxProjectInformation projectInformation) throws InvalidSPDXAnalysisException {
        String[] parameterCreators;
        ArrayList<String> creators = new ArrayList<String>();
        for (String parameterCreator : parameterCreators = projectInformation.getCreators()) {
            String verify = SpdxVerificationHelper.verifyCreator((String)parameterCreator);
            if (verify == null) {
                creators.add(parameterCreator);
                continue;
            }
            LOG.warn("Invalid creator string ( " + verify + " ), " + parameterCreator + " will be skipped.");
        }
        SpdxCreatorInformation spdxCreator = this.spdxDoc.createCreationInfo(creators, this.format.format(new Date()));
        spdxCreator.setComment(projectInformation.getCreatorComment());
        spdxCreator.setLicenseListVersion(ListedLicenses.getListedLicenses().getLicenseListVersion());
        this.spdxDoc.setCreationInfo(spdxCreator);
    }

    public void collectSpdxFileInformation(List<FileSet> sources, String baseDir, SpdxDefaultFileInformation defaultFileInformation, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, Set<ChecksumAlgorithm> algorithms) throws SpdxBuilderException {
        SpdxFileCollector fileCollector = new SpdxFileCollector();
        try {
            fileCollector.collectFiles(sources, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, RelationshipType.GENERATES, this.spdxDoc, algorithms);
            this.projectPackage.getFiles().addAll(fileCollector.getFiles());
            this.projectPackage.getLicenseInfoFromFiles().addAll(fileCollector.getLicenseInfoFromFiles());
        }
        catch (InvalidSPDXAnalysisException | SpdxCollectionException e) {
            throw new SpdxBuilderException("Error collecting SPDX file information", e);
        }
        try {
            String spdxFileName = this.spdxFile.getPath().replace("\\", "/");
            this.projectPackage.setPackageVerificationCode(fileCollector.getVerificationCode(spdxFileName, this.spdxDoc));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SpdxBuilderException("Unable to calculate verification code", e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Unable to update verification code", e);
        }
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public SpdxPackage getProjectPackage() {
        return this.projectPackage;
    }
}

