/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import org.spdx.library.model.enumerations.Purpose;

public enum Packaging {
    POM("pom", Purpose.INSTALL),
    EJB("ejb", Purpose.LIBRARY),
    JAR("jar", Purpose.LIBRARY),
    MAVEN_PLUGIN("maven-plugin", Purpose.LIBRARY),
    WAR("war", Purpose.APPLICATION),
    EAR("ear", Purpose.APPLICATION),
    RAR("rar", Purpose.OTHER);

    private final String name;
    private final Purpose purpose;

    private Packaging(String name, Purpose purpose) {
        this.name = name;
        this.purpose = purpose;
    }

    public static Packaging valueOfPackaging(String packagingValue) {
        packagingValue = packagingValue.toLowerCase();
        for (Packaging packaging : Packaging.values()) {
            if (!packaging.name.equals(packagingValue)) continue;
            return packaging;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Purpose getPurpose() {
        return this.purpose;
    }
}

