/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerAlternative;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerMixed;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerMixedAlternative;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerMixedRelated;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerMixedRelatedAlternative;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerRelated;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerRelatedAlternative;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerSimple;
import org.simplejavamail.converter.internal.mimemessage.SpecializedMimeMessageProducer;
import org.simplejavamail.email.internal.InternalEmail;

public final class MimeMessageProducerHelper {
    private static final List<SpecializedMimeMessageProducer> mimeMessageProducers = Arrays.asList(new MimeMessageProducerSimple(), new MimeMessageProducerAlternative(), new MimeMessageProducerRelated(), new MimeMessageProducerMixed(), new MimeMessageProducerMixedRelated(), new MimeMessageProducerMixedAlternative(), new MimeMessageProducerRelatedAlternative(), new MimeMessageProducerMixedRelatedAlternative());

    private MimeMessageProducerHelper() {
    }

    public static MimeMessage produceMimeMessage(Email email, Session session) throws UnsupportedEncodingException, MessagingException {
        assert (email instanceof InternalEmail);
        ((InternalEmail)email).verifyDefaultsAndOverridesApplied();
        for (SpecializedMimeMessageProducer mimeMessageProducer : mimeMessageProducers) {
            if (!mimeMessageProducer.compatibleWithEmail(email)) continue;
            return mimeMessageProducer.populateMimeMessage(email, session);
        }
        throw new IllegalStateException("no compatible SpecializedMimeMessageProducer found for email");
    }
}

