/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.io.Serializable;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.utils.ClassUtils;

public class JobDetailImpl
implements Cloneable,
Serializable,
JobDetail {
    private static final long serialVersionUID = -6069784757781506897L;
    private String name;
    private String group = "DEFAULT";
    private String description;
    private Class<? extends Job> jobClass;
    private JobDataMap jobDataMap;
    private boolean durability = false;
    private boolean shouldRecover = false;
    private transient JobKey key = null;

    public JobDetailImpl() {
    }

    @Deprecated
    public JobDetailImpl(String name, Class<? extends Job> jobClass) {
        this(name, null, jobClass);
    }

    @Deprecated
    public JobDetailImpl(String name, String group, Class<? extends Job> jobClass) {
        this.setName(name);
        this.setGroup(group);
        this.setJobClass(jobClass);
    }

    @Deprecated
    public JobDetailImpl(String name, String group, Class<? extends Job> jobClass, boolean durability, boolean recover) {
        this.setName(name);
        this.setGroup(group);
        this.setJobClass(jobClass);
        this.setDurability(durability);
        this.setRequestsRecovery(recover);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Job name cannot be empty.");
        }
        this.name = name;
        this.key = null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        if (group != null && group.trim().isEmpty()) {
            throw new IllegalArgumentException("Group name cannot be empty.");
        }
        if (group == null) {
            group = "DEFAULT";
        }
        this.group = group;
        this.key = null;
    }

    public String getFullName() {
        return this.group + "." + this.name;
    }

    @Override
    public JobKey getKey() {
        if (this.key == null) {
            if (this.getName() == null) {
                return null;
            }
            this.key = new JobKey(this.getName(), this.getGroup());
        }
        return this.key;
    }

    public void setKey(JobKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        this.setName(key.getName());
        this.setGroup(key.getGroup());
        this.key = key;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Class<? extends Job> getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(Class<? extends Job> jobClass) {
        if (jobClass == null) {
            throw new IllegalArgumentException("Job class cannot be null.");
        }
        if (!Job.class.isAssignableFrom(jobClass)) {
            throw new IllegalArgumentException("Job class must implement the Job interface.");
        }
        this.jobClass = jobClass;
    }

    @Override
    public JobDataMap getJobDataMap() {
        if (this.jobDataMap == null) {
            this.jobDataMap = new JobDataMap();
        }
        return this.jobDataMap;
    }

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public void setDurability(boolean durability) {
        this.durability = durability;
    }

    public void setRequestsRecovery(boolean shouldRecover) {
        this.shouldRecover = shouldRecover;
    }

    @Override
    public boolean isDurable() {
        return this.durability;
    }

    @Override
    public boolean isPersistJobDataAfterExecution() {
        return ClassUtils.isAnnotationPresent(this.jobClass, PersistJobDataAfterExecution.class);
    }

    @Override
    public boolean isConcurrentExecutionDisallowed() {
        return ClassUtils.isAnnotationPresent(this.jobClass, DisallowConcurrentExecution.class);
    }

    @Override
    public boolean requestsRecovery() {
        return this.shouldRecover;
    }

    public String toString() {
        return "JobDetail '" + this.getFullName() + "':  jobClass: '" + (this.getJobClass() == null ? null : this.getJobClass().getName()) + " concurrentExecutionDisallowed: " + this.isConcurrentExecutionDisallowed() + " persistJobDataAfterExecution: " + this.isPersistJobDataAfterExecution() + " isDurable: " + this.isDurable() + " requestsRecovers: " + this.requestsRecovery();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobDetail)) {
            return false;
        }
        JobDetail other = (JobDetail)obj;
        if (other.getKey() == null || this.getKey() == null) {
            return false;
        }
        return other.getKey().equals(this.getKey());
    }

    public int hashCode() {
        JobKey key = this.getKey();
        return key == null ? 0 : this.getKey().hashCode();
    }

    @Override
    public Object clone() {
        JobDetailImpl copy;
        try {
            copy = (JobDetailImpl)super.clone();
            if (this.jobDataMap != null) {
                copy.jobDataMap = (JobDataMap)this.jobDataMap.clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }

    @Override
    public JobBuilder getJobBuilder() {
        JobBuilder b = JobBuilder.newJob().ofType(this.getJobClass()).requestRecovery(this.requestsRecovery()).storeDurably(this.isDurable()).usingJobData(this.getJobDataMap()).withDescription(this.getDescription()).withIdentity(this.getKey());
        return b;
    }
}

