/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.filter.parser;

import java.util.Locale;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.shrink.ResizeRequest;
import org.opensearch.action.admin.indices.shrink.ResizeResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.ActiveShardsObserver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.controlcenter.notification.filter.NotificationActionListener;
import org.opensearch.indexmanagement.controlcenter.notification.filter.OperationResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ResponseParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ*\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0016J0\u0010\"\u001a\u00020#2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u000e\u0010$\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ResizeIndexRespParser;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ResponseParser;", "Lorg/opensearch/action/admin/indices/shrink/ResizeResponse;", "activeShardsObserver", "Lorg/opensearch/action/support/ActiveShardsObserver;", "request", "Lorg/opensearch/action/admin/indices/shrink/ResizeRequest;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/action/support/ActiveShardsObserver;Lorg/opensearch/action/admin/indices/shrink/ResizeRequest;Lorg/opensearch/cluster/service/ClusterService;)V", "getActiveShardsObserver", "()Lorg/opensearch/action/support/ActiveShardsObserver;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "indexWithCluster", "", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "getRequest", "()Lorg/opensearch/action/admin/indices/shrink/ResizeRequest;", "totalWaitTime", "Lorg/opensearch/common/unit/TimeValue;", "buildNotificationMessage", "response", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isTimeout", "", "buildNotificationTitle", "operationResult", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/OperationResult;", "parseAndSendNotification", "", "ex", "callback", "Ljava/util/function/Consumer;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ActionRespParseResult;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nResizeIndexRespParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResizeIndexRespParser.kt\norg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ResizeIndexRespParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
public final class ResizeIndexRespParser
implements ResponseParser<ResizeResponse> {
    @NotNull
    private final ActiveShardsObserver activeShardsObserver;
    @NotNull
    private final ResizeRequest request;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Logger logger;
    @NotNull
    private TimeValue totalWaitTime;
    @Nullable
    private final String indexWithCluster;

    public ResizeIndexRespParser(@NotNull ActiveShardsObserver activeShardsObserver, @NotNull ResizeRequest request, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)activeShardsObserver, (String)"activeShardsObserver");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.activeShardsObserver = activeShardsObserver;
        this.request = request;
        this.clusterService = clusterService;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.totalWaitTime = NotificationActionListener.Companion.getMAX_WAIT_TIME();
        this.indexWithCluster = this.getIndexName((ActionRequest)this.request, this.clusterService);
    }

    @NotNull
    public final ActiveShardsObserver getActiveShardsObserver() {
        return this.activeShardsObserver;
    }

    @NotNull
    public final ResizeRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    public void parseAndSendNotification(@Nullable ResizeResponse response2, @Nullable Exception ex, @NotNull Consumer<ActionRespParseResult> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean isAsync = this.request.getShouldStoreResult();
        if (ex != null) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, null, ex, false, 4, null), this.buildNotificationTitle(OperationResult.FAILED)));
            return;
        }
        if (response2 == null) {
            boolean $i$a$-requireNotNull-ResizeIndexRespParser$parseAndSendNotification$22 = false;
            String $i$a$-requireNotNull-ResizeIndexRespParser$parseAndSendNotification$22 = "ResizeResponse must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ResizeIndexRespParser$parseAndSendNotification$22.toString());
        }
        if (!response2.isShardsAcknowledged()) {
            this.logger.debug("Not all shards are started, continue monitoring on shards status");
            TimeValue elapsedTime = this.request.getTargetIndexRequest().timeout();
            Intrinsics.checkNotNull((Object)elapsedTime);
            this.totalWaitTime = elapsedTime;
            long leftTimeInMillis = NotificationActionListener.Companion.getMAX_WAIT_TIME().getMillis() - elapsedTime.getMillis();
            if (!isAsync && leftTimeInMillis > 0L) {
                this.totalWaitTime = NotificationActionListener.Companion.getMAX_WAIT_TIME();
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)response2.index(), (String)"index(...)");
                this.activeShardsObserver.waitForActiveShards(stringArray, ActiveShardCount.DEFAULT, new TimeValue(leftTimeInMillis), arg_0 -> ResizeIndexRespParser.parseAndSendNotification$lambda$1(callback, this, response2, arg_0), arg_0 -> ResizeIndexRespParser.parseAndSendNotification$lambda$2(callback, this, response2, arg_0));
            } else {
                callback.accept(new ActionRespParseResult(OperationResult.TIMEOUT, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, (ActionResponse)response2, null, true, 2, null), this.buildNotificationTitle(OperationResult.TIMEOUT)));
            }
        } else {
            callback.accept(new ActionRespParseResult(OperationResult.COMPLETE, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, (ActionResponse)response2, null, false, 6, null), this.buildNotificationTitle(OperationResult.COMPLETE)));
        }
    }

    @Override
    @NotNull
    public String buildNotificationMessage(@Nullable ResizeResponse response2, @Nullable Exception exception, boolean isTimeout) {
        Object object;
        StringBuilder result2 = new StringBuilder();
        String string = this.request.getResizeType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String action = string;
        CreateIndexRequest createIndexRequest = this.request.getTargetIndexRequest();
        Intrinsics.checkNotNullExpressionValue((Object)createIndexRequest, (String)"getTargetIndexRequest(...)");
        StringBuilder stringBuilder = result2.append("The " + action + " operation from " + this.indexWithCluster + " to " + this.getIndexName((ActionRequest)createIndexRequest, this.clusterService) + " ");
        if (isTimeout) {
            object = "has taken more than " + this.totalWaitTime.toHumanReadableString(1) + " to complete. To see the latest status, use `GET /" + this.request.getTargetIndexRequest().index() + "/_recovery`";
        } else {
            if (exception != null) {
                Object object2;
                Exception exception2;
                String message;
                String string2 = exception.getMessage();
                if (string2 == null) {
                    string2 = message = "";
                }
                if ((exception2 = exception) instanceof IllegalStateException) {
                    object2 = StringsKt.contains$default((CharSequence)message, (CharSequence)"must have all shards allocated on the same node", (boolean)false, (int)2, null) ? "You must allocate a copy of every shard of the source index to the same node before " + action + ". To allocate it to same node, try use PUT /" + this.request.getSourceIndex() + "/_settings\n{\n\"index.routing.allocation.require._name\":\"your_node_name\"\n}" : (StringsKt.contains$default((CharSequence)message, (CharSequence)"must block write operations to resize index", (boolean)false, (int)2, null) ? this.indexWithCluster + " must be set to block write to " + action + " the index. To set it to block write, use `PUT /" + this.request.getSourceIndex() + "/_block/write` " : message);
                } else if (exception2 instanceof ResourceAlreadyExistsException) {
                    CreateIndexRequest createIndexRequest2 = this.request.getTargetIndexRequest();
                    Intrinsics.checkNotNullExpressionValue((Object)createIndexRequest2, (String)"getTargetIndexRequest(...)");
                    object2 = "The target index " + this.getIndexName((ActionRequest)createIndexRequest2, this.clusterService) + " already exists.";
                } else {
                    object2 = exception2 instanceof IndexNotFoundException ? "The " + this.indexWithCluster + " does not exist." : message;
                }
                return object2;
            }
            object = "has been completed.";
        }
        stringBuilder.append((String)object);
        String string3 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String buildNotificationTitle(@NotNull OperationResult operationResult) {
        String string;
        StringBuilder builder;
        Intrinsics.checkNotNullParameter((Object)((Object)operationResult), (String)"operationResult");
        StringBuilder $this$buildNotificationTitle_u24lambda_u244 = builder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder = $this$buildNotificationTitle_u24lambda_u244;
        String string2 = this.request.getResizeType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = stringBuilder;
            boolean bl2 = false;
            String string4 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            String string6 = string5;
            stringBuilder = stringBuilder3;
            StringBuilder stringBuilder4 = stringBuilder2.append((Object)string6);
            String string7 = string3;
            int n = 1;
            String string8 = string7.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
            string = stringBuilder4.append(string8).toString();
        } else {
            string = string3;
        }
        stringBuilder.append(string);
        $this$buildNotificationTitle_u24lambda_u244.append(" operation on " + this.indexWithCluster + " has " + this.getOperationResultTitleDesc(operationResult));
        String string9 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(...)");
        return string9;
    }

    @Override
    @Nullable
    public String getIndexName(@NotNull ActionRequest req, @NotNull ClusterService clusterService) {
        return ResponseParser.DefaultImpls.getIndexName(this, req, clusterService);
    }

    @Override
    @NotNull
    public String getOperationResultTitleDesc(@NotNull OperationResult result2) {
        return ResponseParser.DefaultImpls.getOperationResultTitleDesc(this, result2);
    }

    private static final void parseAndSendNotification$lambda$1(Consumer $callback, ResizeIndexRespParser this$0, ResizeResponse $response, boolean shardsAcknowledged) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        OperationResult result2 = shardsAcknowledged ? OperationResult.COMPLETE : OperationResult.TIMEOUT;
        $callback.accept(new ActionRespParseResult(result2, ResponseParser.DefaultImpls.buildNotificationMessage$default(this$0, (ActionResponse)$response, null, !shardsAcknowledged, 2, null), this$0.buildNotificationTitle(result2)));
    }

    private static final void parseAndSendNotification$lambda$2(Consumer $callback, ResizeIndexRespParser this$0, ResizeResponse $response, Exception e) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.DefaultImpls.buildNotificationMessage$default(this$0, (ActionResponse)$response, e, false, 4, null), this$0.buildNotificationTitle(OperationResult.FAILED)));
    }
}

