/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.httpclient5;

import java.io.IOException;
import java.util.Locale;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.opensearch.client.transport.httpclient5.Response;

public final class ResponseException
extends IOException {
    private final Response response;

    ResponseException(Response response) throws IOException {
        super(ResponseException.buildMessage(response));
        this.response = response;
    }

    static String buildMessage(Response response) throws IOException {
        HttpEntity entity;
        Object message = String.format(Locale.ROOT, "method [%s], host [%s], URI [%s], status line [%s]", response.getRequestLine().getMethod(), response.getHost(), response.getRequestLine().getUri(), response.getStatusLine().toString());
        if (response.hasWarnings()) {
            message = (String)message + "\nWarnings: " + response.getWarnings();
        }
        if ((entity = response.getEntity()) != null) {
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
                response.getHttpResponse().setEntity(entity);
            }
            try {
                message = (String)message + "\n" + EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException ex) {
                throw new IOException(ex);
            }
        }
        return message;
    }

    public Response getResponse() {
        return this.response;
    }
}

