/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.json.DelegatingJsonParser;
import org.opensearch.client.json.JsonLocationImpl;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.LookAheadJsonParser;
import org.opensearch.client.json.UnexpectedJsonEventException;
import org.opensearch.client.util.ObjectBuilder;

public class JsonpUtils {
    public static JsonParser.Event expectNextEvent(JsonParser parser, JsonParser.Event expected) {
        JsonParser.Event event = parser.next();
        JsonpUtils.expectEvent(parser, expected, event);
        return event;
    }

    public static void expectEvent(JsonParser parser, JsonParser.Event expected, JsonParser.Event event) {
        if (event != expected) {
            throw new UnexpectedJsonEventException(parser, event, expected);
        }
    }

    public static String expectKeyName(JsonParser parser, JsonParser.Event event) {
        JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
        return parser.getString();
    }

    public static void ensureAccepts(JsonpDeserializer<?> deserializer, JsonParser parser, JsonParser.Event event) {
        if (!deserializer.acceptedEvents().contains(event)) {
            throw new UnexpectedJsonEventException(parser, event, deserializer.acceptedEvents());
        }
    }

    public static void skipValue(JsonParser parser) {
        JsonpUtils.skipValue(parser, parser.next());
    }

    public static void skipValue(JsonParser parser, JsonParser.Event event) {
        switch (event) {
            case START_OBJECT: {
                parser.skipObject();
                break;
            }
            case START_ARRAY: {
                parser.skipArray();
                break;
            }
        }
    }

    public static <T> T buildVariant(JsonParser parser, ObjectBuilder<T> builder) {
        if (builder == null) {
            throw new JsonParsingException("No variant found", parser.getLocation());
        }
        return builder.build();
    }

    public static <T> void serialize(T value, JsonGenerator generator, @Nullable JsonpSerializer<T> serializer, JsonpMapper mapper) {
        if (serializer != null) {
            serializer.serialize(value, generator, mapper);
        } else if (value instanceof JsonpSerializable) {
            ((JsonpSerializable)value).serialize(generator, mapper);
        } else {
            mapper.serialize(value, generator);
        }
    }

    public static Map.Entry<String, JsonParser> lookAheadFieldValue(String name, String defaultValue, JsonParser parser, JsonpMapper mapper) {
        final JsonLocation location = parser.getLocation();
        if (parser instanceof LookAheadJsonParser) {
            Map.Entry<String, JsonParser> result = ((LookAheadJsonParser)parser).lookAheadFieldValue(name, defaultValue);
            if (result.getKey() == null) {
                throw new JsonParsingException("Property '" + name + "' not found", location);
            }
            return result;
        }
        JsonObject object = parser.getObject();
        String result = object.getString(name, null);
        if (result == null) {
            result = defaultValue;
        }
        if (result == null) {
            throw new JsonParsingException("Property '" + name + "' not found", location);
        }
        JsonParser newParser = JsonpUtils.objectParser(object, mapper);
        newParser = new DelegatingJsonParser(newParser){

            @Override
            public JsonLocation getLocation() {
                return new JsonLocationImpl(location.getLineNumber(), location.getColumnNumber(), location.getStreamOffset()){

                    @Override
                    public String toString() {
                        return "(in object at " + super.toString().substring(1);
                    }
                };
            }
        };
        return new AbstractMap.SimpleImmutableEntry<String, JsonParser>(result, newParser);
    }

    public static JsonParser objectParser(JsonObject object, JsonpMapper mapper) {
        String strObject = object.toString();
        return mapper.jsonProvider().createParser((Reader)new StringReader(strObject));
    }

    public static String toString(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                throw new IllegalArgumentException("Json objects cannot be used as string");
            }
            case ARRAY: {
                return value.asJsonArray().stream().map(JsonpUtils::toString).collect(Collectors.joining(","));
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case NULL: {
                return "null";
            }
            case NUMBER: {
                return value.toString();
            }
        }
        throw new IllegalArgumentException("Unknown JSON value type: '" + value + "'");
    }

    public static void serializeDoubleOrNull(JsonGenerator generator, double value, double defaultValue) {
        if (value == defaultValue && !Double.isFinite(defaultValue)) {
            generator.writeNull();
        } else {
            generator.write(value);
        }
    }

    public static void serializeIntOrNull(JsonGenerator generator, int value, int defaultValue) {
        if (value == defaultValue && defaultValue == Integer.MAX_VALUE || defaultValue == Integer.MIN_VALUE) {
            generator.writeNull();
        } else {
            generator.write(value);
        }
    }
}

