/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IntegrityCheckAlgorithm implements Enumerator
{
    SHA1(0, "SHA1", "SHA-1"),
    SHA256(1, "SHA256", "SHA-256");

    public static final int SHA1_VALUE = 0;
    public static final int SHA256_VALUE = 1;
    private static final IntegrityCheckAlgorithm[] VALUES_ARRAY;
    public static final List<IntegrityCheckAlgorithm> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IntegrityCheckAlgorithm[]{SHA1, SHA256};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IntegrityCheckAlgorithm get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntegrityCheckAlgorithm result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntegrityCheckAlgorithm getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntegrityCheckAlgorithm result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntegrityCheckAlgorithm get(int value) {
        switch (value) {
            case 0: {
                return SHA1;
            }
            case 1: {
                return SHA256;
            }
        }
        return null;
    }

    private IntegrityCheckAlgorithm(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

