/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimingEvent implements Enumerator
{
    AC(0, "AC", "AC"),
    ACD(1, "ACD", "ACD"),
    ACM(2, "ACM", "ACM"),
    ACV(3, "ACV", "ACV"),
    HS(4, "HS", "HS"),
    IC(5, "IC", "IC"),
    ICD(6, "ICD", "ICD"),
    ICM(7, "ICM", "ICM"),
    ICV(8, "ICV", "ICV"),
    PC(9, "PC", "PC"),
    PCD(10, "PCD", "PCD"),
    PCM(11, "PCM", "PCM"),
    PCV(12, "PCV", "PCV");

    public static final int AC_VALUE = 0;
    public static final int ACD_VALUE = 1;
    public static final int ACM_VALUE = 2;
    public static final int ACV_VALUE = 3;
    public static final int HS_VALUE = 4;
    public static final int IC_VALUE = 5;
    public static final int ICD_VALUE = 6;
    public static final int ICM_VALUE = 7;
    public static final int ICV_VALUE = 8;
    public static final int PC_VALUE = 9;
    public static final int PCD_VALUE = 10;
    public static final int PCM_VALUE = 11;
    public static final int PCV_VALUE = 12;
    private static final TimingEvent[] VALUES_ARRAY;
    public static final List<TimingEvent> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimingEvent[]{AC, ACD, ACM, ACV, HS, IC, ICD, ICM, ICV, PC, PCD, PCM, PCV};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimingEvent get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimingEvent result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimingEvent getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimingEvent result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimingEvent get(int value) {
        switch (value) {
            case 0: {
                return AC;
            }
            case 1: {
                return ACD;
            }
            case 2: {
                return ACM;
            }
            case 3: {
                return ACV;
            }
            case 4: {
                return HS;
            }
            case 5: {
                return IC;
            }
            case 6: {
                return ICD;
            }
            case 7: {
                return ICM;
            }
            case 8: {
                return ICV;
            }
            case 9: {
                return PC;
            }
            case 10: {
                return PCD;
            }
            case 11: {
                return PCM;
            }
            case 12: {
                return PCV;
            }
        }
        return null;
    }

    private TimingEvent(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

