/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.cdt.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.eclipse.emf.common.util.Diagnostic;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.cdt.CDTFactory;
import org.openhealthtools.mdht.uml.cda.cdt.ConsultationNote;
import org.openhealthtools.mdht.uml.cda.cdt.ReasonForReferralSection;
import org.openhealthtools.mdht.uml.cda.util.BasicValidationHandler;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.openhealthtools.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.openhealthtools.mdht.uml.hl7.datatypes.INT;

public class Main {
    public static void main(String[] args) throws Exception {
        ConsultationNote consultationNote = CDTFactory.eINSTANCE.createConsultationNote().init();
        consultationNote.getCode().setCode("11488-4");
        consultationNote.getCode().setDisplayName("CONSULTATION NOTE");
        consultationNote.setTitle(DatatypesFactory.eINSTANCE.createST("Good Health Pain Management Consultants Consultation Note"));
        consultationNote.setEffectiveTime(DatatypesFactory.eINSTANCE.createTS("20070303171504+0500"));
        consultationNote.setId(DatatypesFactory.eINSTANCE.createII(UUID.randomUUID().toString(), "999021"));
        consultationNote.setConfidentialityCode(DatatypesFactory.eINSTANCE.createCE("N", "2.16.840.1.113883.5.25"));
        INT one = DatatypesFactory.eINSTANCE.createINT();
        one.setValue(Integer.valueOf(1));
        consultationNote.setVersionNumber(one);
        ReasonForReferralSection referralSection = CDTFactory.eINSTANCE.createReasonForReferralSection().init();
        consultationNote.addSection(referralSection);
        System.out.println("***** Generate Consultation Note *****");
        Main.save(consultationNote);
        System.out.println("\n\n***** Validate generated Consultation Note *****");
        Main.validate(consultationNote);
        System.out.println("\n***** Validate sample H & P *****");
        ClinicalDocument sampleHandP = CDAUtil.load((InputStream)new FileInputStream("samples/HandP.sample.xml"));
        Main.validate(sampleHandP);
        System.out.println("\n***** Validate sample Consultation Note *****");
        ClinicalDocument sampleConsultNote = CDAUtil.load((InputStream)new FileInputStream("samples/Consults.Sample.xml"));
        Main.validate(sampleConsultNote);
        System.out.println("\n***** Validate sample Progress Note *****");
        ClinicalDocument sampleProgressNote = CDAUtil.load((InputStream)new FileInputStream("samples/Progress_Note.xml"));
        Main.validate(sampleProgressNote);
    }

    private static void save(ClinicalDocument clinicalDocument) throws Exception {
        CDAUtil.save((ClinicalDocument)clinicalDocument, (OutputStream)System.out);
    }

    private static void validate(ClinicalDocument clinicalDocument) throws Exception {
        boolean valid = CDAUtil.validate((ClinicalDocument)clinicalDocument, (CDAUtil.ValidationHandler)new BasicValidationHandler(){

            public void handleError(Diagnostic diagnostic) {
                System.out.println("ERROR: " + diagnostic.getMessage());
            }

            public void handleWarning(Diagnostic diagnostic) {
                System.out.println("WARNING: " + diagnostic.getMessage());
            }

            public void handleInfo(Diagnostic diagnostic) {
                System.out.println("INFO: " + diagnostic.getMessage());
            }
        });
        if (valid) {
            System.out.println("Document is valid");
        } else {
            System.out.println("Document is invalid");
        }
    }
}

