/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.ccd.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.openhealthtools.mdht.uml.cda.AssignedEntity;
import org.openhealthtools.mdht.uml.cda.CDAFactory;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.EntryRelationship;
import org.openhealthtools.mdht.uml.cda.Informant12;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.ccd.CCDFactory;
import org.openhealthtools.mdht.uml.cda.ccd.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.ccd.EpisodeObservation;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemAct;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemHealthStatusObservation;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemObservation;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemSection;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemStatusObservation;
import org.openhealthtools.mdht.uml.cda.ccd.PurposeActivity;
import org.openhealthtools.mdht.uml.cda.ccd.PurposeSection;
import org.openhealthtools.mdht.uml.cda.ccd.ResultObservation;
import org.openhealthtools.mdht.uml.cda.ccd.ResultOrganizer;
import org.openhealthtools.mdht.uml.cda.ccd.ResultsSection;
import org.openhealthtools.mdht.uml.cda.util.BasicValidationHandler;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.openhealthtools.mdht.uml.cda.util.ValidationResult;
import org.openhealthtools.mdht.uml.hl7.vocab.x_ActRelationshipEntryRelationship;

public class Main {
    public static void main(String[] args) throws Exception {
        ContinuityOfCareDocument doc = CCDFactory.eINSTANCE.createContinuityOfCareDocument().init();
        Informant12 informant = CDAFactory.eINSTANCE.createInformant12();
        AssignedEntity assignedEntity = CDAFactory.eINSTANCE.createAssignedEntity();
        informant.setAssignedEntity(assignedEntity);
        doc.getInformants().add((Object)informant);
        PurposeSection purposeSection = CCDFactory.eINSTANCE.createPurposeSection().init();
        doc.addSection(purposeSection);
        PurposeActivity purposeActivity = CCDFactory.eINSTANCE.createPurposeActivity().init();
        purposeSection.addAct(purposeActivity);
        SubstanceAdministration purposeReason = CDAFactory.eINSTANCE.createSubstanceAdministration();
        purposeActivity.addSubstanceAdministration(purposeReason);
        ((EntryRelationship)purposeActivity.getEntryRelationships().get(0)).setTypeCode(x_ActRelationshipEntryRelationship.RSON);
        ProblemAct problemAct = CCDFactory.eINSTANCE.createProblemAct().init();
        ProblemObservation problemObservation = CCDFactory.eINSTANCE.createProblemObservation().init();
        ProblemStatusObservation problemStatus = CCDFactory.eINSTANCE.createProblemStatusObservation().init();
        ProblemHealthStatusObservation problemHealthStatus = CCDFactory.eINSTANCE.createProblemHealthStatusObservation().init();
        EpisodeObservation episodeObservation = CCDFactory.eINSTANCE.createEpisodeObservation().init();
        ProblemSection problemSection = CCDFactory.eINSTANCE.createProblemSection().init();
        doc.addSection(problemSection);
        problemSection.addAct(problemAct);
        problemAct.addObservation(problemObservation);
        problemSection.addObservation(problemStatus);
        problemSection.addObservation(problemHealthStatus);
        problemSection.addObservation(episodeObservation);
        ResultsSection resultsSection = CCDFactory.eINSTANCE.createResultsSection().init();
        doc.addSection(resultsSection);
        ResultOrganizer resultOrganizer = CCDFactory.eINSTANCE.createResultOrganizer().init();
        resultsSection.addOrganizer(resultOrganizer);
        ResultObservation resultObservation = CCDFactory.eINSTANCE.createResultObservation().init();
        resultOrganizer.addObservation(resultObservation);
        System.out.println("***** Generate CCD *****");
        CDAUtil.save((ClinicalDocument)doc, (OutputStream)System.out);
        System.out.println("\n\n***** Validate generated CCD *****");
        Main.validate(doc);
        System.out.println("\n***** Validate sample CCD *****");
        ValidationResult result = new ValidationResult();
        CDAUtil.load((InputStream)new FileInputStream("samples/SampleCCDDocument.xml"), (CDAUtil.ValidationHandler)result);
        for (Diagnostic diagnostic : result.getErrorDiagnostics()) {
            System.out.println("ERROR: " + diagnostic.getMessage());
        }
        for (Diagnostic diagnostic : result.getWarningDiagnostics()) {
            System.out.println("WARNING: " + diagnostic.getMessage());
        }
    }

    private static void validate(ClinicalDocument clinicalDocument) throws Exception {
        boolean valid = CDAUtil.validate((ClinicalDocument)clinicalDocument, (CDAUtil.ValidationHandler)new BasicValidationHandler(){

            public void handleError(Diagnostic diagnostic) {
                System.out.println("ERROR: " + diagnostic.getMessage());
            }

            public void handleWarning(Diagnostic diagnostic) {
                System.out.println("WARNING: " + diagnostic.getMessage());
            }
        });
        if (valid) {
            System.out.println("Document is valid");
        } else {
            System.out.println("Document is invalid");
        }
    }
}

