/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.elytron;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.AuthorityKeyIdentifierExtension;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.CertificatePoliciesExtension;
import org.wildfly.security.x500.cert.ExtendedKeyUsageExtension;
import org.wildfly.security.x500.cert.KeyUsage;
import org.wildfly.security.x500.cert.KeyUsageExtension;
import org.wildfly.security.x500.cert.SubjectKeyIdentifierExtension;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;
import org.wildfly.security.x500.cert.util.KeyUtil;

public class ElytronCertificateUtilsProvider
implements CertificateUtilsProvider {
    Logger log = Logger.getLogger(this.getClass());

    public X509Certificate generateV3Certificate(KeyPair keyPair, PrivateKey caPrivateKey, X509Certificate caCert, String subject) throws Exception {
        try {
            X500Principal subjectdn = ElytronCertificateUtilsProvider.subjectToX500Principle(subject);
            X500Principal issuerdn = caCert.getSubjectX500Principal();
            ZonedDateTime notBefore = ZonedDateTime.ofInstant(new Date(System.currentTimeMillis()).toInstant(), ZoneId.systemDefault());
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, 3);
            Date validityEndDate = new Date(calendar.getTime().getTime());
            ZonedDateTime notAfter = ZonedDateTime.ofInstant(validityEndDate.toInstant(), ZoneId.systemDefault());
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            BigInteger serialNumber = BigInteger.valueOf(Math.abs(random.nextInt()));
            ArrayList<String> ekuList = new ArrayList<String>();
            ekuList.add("1.3.6.1.5.5.7.3.4");
            ekuList.add("1.3.6.1.5.5.7.3.1");
            X509CertificateBuilder cbuilder = new X509CertificateBuilder().setSubjectDn(subjectdn).setIssuerDn(issuerdn).setNotValidBefore(notBefore).setNotValidAfter(notAfter).setPublicKey(keyPair.getPublic()).setSerialNumber(serialNumber).setSignatureAlgorithmName("SHA256withRSA").setSigningKey(caPrivateKey).addExtension((X509CertificateExtension)new SubjectKeyIdentifierExtension(KeyUtil.getKeyIdentifier((PublicKey)keyPair.getPublic()))).addExtension((X509CertificateExtension)new AuthorityKeyIdentifierExtension(KeyUtil.getKeyIdentifier((PublicKey)caCert.getPublicKey()), Collections.singletonList(new GeneralName.DirectoryName(caCert.getIssuerX500Principal().getName())), caCert.getSerialNumber())).addExtension((X509CertificateExtension)new KeyUsageExtension(new KeyUsage[]{KeyUsage.digitalSignature, KeyUsage.keyCertSign, KeyUsage.cRLSign})).addExtension((X509CertificateExtension)new ExtendedKeyUsageExtension(false, ekuList)).addExtension((X509CertificateExtension)new BasicConstraintsExtension(true, true, 0));
            return cbuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating X509v3Certificate.", e);
        }
    }

    public X509Certificate generateV1SelfSignedCertificate(KeyPair caKeyPair, String subject) {
        return this.generateV1SelfSignedCertificate(caKeyPair, subject, BigInteger.valueOf(System.currentTimeMillis()));
    }

    public X509Certificate generateV1SelfSignedCertificate(KeyPair caKeyPair, String subject, BigInteger serialNumber) {
        try {
            X500Principal subjectdn = ElytronCertificateUtilsProvider.subjectToX500Principle(subject);
            ZonedDateTime notBefore = ZonedDateTime.ofInstant(new Date(System.currentTimeMillis() - 100000L).toInstant(), ZoneId.systemDefault());
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, 10);
            Date validityEndDate = new Date(calendar.getTime().getTime());
            ZonedDateTime notAfter = ZonedDateTime.ofInstant(validityEndDate.toInstant(), ZoneId.systemDefault());
            X509CertificateBuilder cbuilder = new X509CertificateBuilder().setSubjectDn(subjectdn).setIssuerDn(subjectdn).setNotValidBefore(notBefore).setNotValidAfter(notAfter).setSigningKey(caKeyPair.getPrivate()).setPublicKey(caKeyPair.getPublic()).setSerialNumber(serialNumber).setSignatureAlgorithmName("SHA256withRSA");
            return cbuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating X509v1Certificate.", e);
        }
    }

    private static X500Principal subjectToX500Principle(String subject) {
        if (!subject.startsWith("CN=")) {
            subject = "CN=" + subject;
        }
        return new X500Principal(subject);
    }

    public List<String> getCertificatePolicyList(X509Certificate cert) throws GeneralSecurityException {
        byte[] policy = cert.getExtensionValue("2.5.29.32");
        System.out.println("Policy: " + new String(policy));
        DERDecoder decPolicy = new DERDecoder(policy);
        int type = decPolicy.peekType();
        System.out.println("type " + type);
        DERDecoder der = new DERDecoder(decPolicy.decodeOctetString());
        ArrayList<String> policyList = new ArrayList<String>();
        block4: while (der.hasNextElement()) {
            switch (der.peekType()) {
                case 48: {
                    der.startSequence();
                    continue block4;
                }
                case 6: {
                    policyList.add(der.decodeObjectIdentifier());
                    der.endSequence();
                    continue block4;
                }
            }
            der.skipElement();
        }
        return policyList;
    }

    public List<String> getCRLDistributionPoints(X509Certificate cert) throws IOException {
        byte[] data = cert.getExtensionValue("2.5.29.31");
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<String> distPointUrls = new ArrayList<String>();
        DERDecoder der = new DERDecoder(data);
        der = new DERDecoder(der.decodeOctetString());
        while (der.hasNextElement()) {
            switch (der.peekType()) {
                case 48: {
                    der.startSequence();
                    break;
                }
                case 12: {
                    distPointUrls.add(der.decodeUtf8String());
                    break;
                }
                case 160: {
                    der.startExplicit(160);
                    break;
                }
                case 134: {
                    der.decodeImplicit(134);
                    distPointUrls.add(der.decodeOctetStringAsString());
                    this.log.debug((Object)("Adding Dist point name: " + (String)distPointUrls.get(distPointUrls.size() - 1)));
                    break;
                }
                default: {
                    der.skipElement();
                }
            }
            try {
                if (!der.hasNextElement() && der.peekType() == 48) {
                    der.startSequence();
                    continue;
                }
                if (der.hasNextElement() || der.peekType() != 160) continue;
                der.startExplicit(160);
            }
            catch (Exception e) {
                this.log.warn((Object)"There is an issue parsing the certificate for Distribution Points", (Throwable)e);
            }
        }
        return distPointUrls;
    }

    public X509Certificate createServicesTestCertificate(String dn, Date startDate, Date expiryDate, KeyPair keyPair, String ... certificatePolicyOid) {
        try {
            X500Principal subjectdn = ElytronCertificateUtilsProvider.subjectToX500Principle(dn);
            X500Principal issuerdn = ElytronCertificateUtilsProvider.subjectToX500Principle(dn);
            ZonedDateTime notValidBefore = ZonedDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault());
            ZonedDateTime notValidAfter = ZonedDateTime.ofInstant(expiryDate.toInstant(), ZoneId.systemDefault());
            X509CertificateBuilder cbuilder = new X509CertificateBuilder().setSubjectDn(subjectdn).setIssuerDn(issuerdn).setNotValidBefore(notValidBefore).setNotValidAfter(notValidAfter).setSigningKey(keyPair.getPrivate()).setPublicKey(keyPair.getPublic()).addExtension(this.createPoliciesExtension(certificatePolicyOid)).setSignatureAlgorithmName("SHA256withRSA");
            return cbuilder.build();
        }
        catch (CertificateException | DateTimeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private X509CertificateExtension createPoliciesExtension(String[] certificatePolicyOid) {
        ArrayList<CertificatePoliciesExtension.PolicyInformation> policyList = new ArrayList<CertificatePoliciesExtension.PolicyInformation>();
        for (String policyOid : certificatePolicyOid) {
            policyList.add(new CertificatePoliciesExtension.PolicyInformation(policyOid));
        }
        return new CertificatePoliciesExtension(false, policyList);
    }
}

