/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import jakarta.json.bind.annotation.JsonbDateFormat;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbPropertyOrder;
import jakarta.json.bind.annotation.JsonbTransient;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.AbstractAnnotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.rules.FormatRule;

public class Jsonb2Annotator
extends AbstractAnnotator {
    public Jsonb2Annotator(GenerationConfig generationConfig) {
        super(generationConfig);
    }

    @Override
    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        JAnnotationArrayMember annotationValue = clazz.annotate(JsonbPropertyOrder.class).paramArray("value");
        Iterator properties = propertiesNode.fieldNames();
        while (properties.hasNext()) {
            annotationValue.param((String)properties.next());
        }
    }

    @Override
    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        field.annotate(JsonbProperty.class).param("value", propertyName);
    }

    @Override
    public void propertyGetter(JMethod getter, JDefinedClass clazz, String propertyName) {
        getter.annotate(JsonbProperty.class).param("value", propertyName);
    }

    @Override
    public void propertySetter(JMethod setter, JDefinedClass clazz, String propertyName) {
        setter.annotate(JsonbProperty.class).param("value", propertyName);
    }

    @Override
    public boolean isAdditionalPropertiesSupported() {
        return true;
    }

    @Override
    public void additionalPropertiesField(JFieldVar field, JDefinedClass clazz, String propertyName) {
        field.annotate(JsonbTransient.class);
    }

    @Override
    public void dateField(JFieldVar field, JDefinedClass clazz, JsonNode node) {
        String pattern = null;
        if (node.has("customDatePattern")) {
            pattern = node.get("customDatePattern").asText();
        } else if (node.has("customPattern")) {
            pattern = node.get("customPattern").asText();
        } else if (StringUtils.isNotEmpty((CharSequence)this.getGenerationConfig().getCustomDatePattern())) {
            pattern = this.getGenerationConfig().getCustomDatePattern();
        } else if (this.getGenerationConfig().isFormatDates()) {
            pattern = FormatRule.ISO_8601_DATE_FORMAT;
        }
        if (!field.type().fullName().equals("java.lang.String")) {
            pattern = pattern != null ? pattern : FormatRule.ISO_8601_DATE_FORMAT;
            field.annotate(JsonbDateFormat.class).param("value", pattern);
        }
    }

    @Override
    public void timeField(JFieldVar field, JDefinedClass clazz, JsonNode node) {
        String pattern = null;
        if (node.has("customTimePattern")) {
            pattern = node.get("customTimePattern").asText();
        } else if (node.has("customPattern")) {
            pattern = node.get("customPattern").asText();
        } else if (StringUtils.isNotEmpty((CharSequence)this.getGenerationConfig().getCustomTimePattern())) {
            pattern = this.getGenerationConfig().getCustomTimePattern();
        } else if (this.getGenerationConfig().isFormatDates()) {
            pattern = FormatRule.ISO_8601_TIME_FORMAT;
        }
        if (!field.type().fullName().equals("java.lang.String")) {
            pattern = pattern != null ? pattern : FormatRule.ISO_8601_TIME_FORMAT;
            field.annotate(JsonbDateFormat.class).param("value", pattern);
        }
    }

    @Override
    public void dateTimeField(JFieldVar field, JDefinedClass clazz, JsonNode node) {
        String pattern = null;
        if (node.has("customDateTimePattern")) {
            pattern = node.get("customDateTimePattern").asText();
        } else if (node.has("customPattern")) {
            pattern = node.get("customPattern").asText();
        } else if (StringUtils.isNotEmpty((CharSequence)this.getGenerationConfig().getCustomDateTimePattern())) {
            pattern = this.getGenerationConfig().getCustomDateTimePattern();
        } else if (this.getGenerationConfig().isFormatDateTimes()) {
            pattern = FormatRule.ISO_8601_DATETIME_FORMAT;
        }
        if (!field.type().fullName().equals("java.lang.String")) {
            pattern = pattern != null ? pattern : FormatRule.ISO_8601_DATETIME_FORMAT;
            field.annotate(JsonbDateFormat.class).param("value", pattern);
        }
    }
}

