/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.server;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.janusgraph.graphdb.server.util.JanusGraphSettingsUtils;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class JanusGraphSettings
extends Settings {
    private GrpcServerSettings grpcServer = new GrpcServerSettings();

    public static JanusGraphSettings read(String file) throws Exception {
        FileInputStream input = new FileInputStream(file);
        return JanusGraphSettings.read(input);
    }

    public static JanusGraphSettings read(InputStream stream) {
        Objects.requireNonNull(stream);
        Constructor constructor = new Constructor(JanusGraphSettings.class, new LoaderOptions());
        TypeDescription grpcServerSettings = new TypeDescription(GrpcServerSettings.class);
        constructor.addTypeDescription(grpcServerSettings);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        JanusGraphSettings settings = (JanusGraphSettings)((Object)yaml.loadAs(stream, JanusGraphSettings.class));
        return JanusGraphSettingsUtils.configureDefaults(settings);
    }

    public GrpcServerSettings getGrpcServer() {
        return this.grpcServer;
    }

    public void setGrpcServer(GrpcServerSettings grpcServer) {
        this.grpcServer = grpcServer;
    }

    public static class GrpcServerSettings {
        private boolean enabled = false;
        private int port = 10182;

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

