/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc;

import com.jcabi.manifests.Manifests;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import org.janusgraph.graphdb.grpc.GetJanusGraphContextByGraphNameRequest;
import org.janusgraph.graphdb.grpc.GetJanusGraphContextByGraphNameResponse;
import org.janusgraph.graphdb.grpc.GetJanusGraphContextsRequest;
import org.janusgraph.graphdb.grpc.GetJanusGraphContextsResponse;
import org.janusgraph.graphdb.grpc.GetVersionRequest;
import org.janusgraph.graphdb.grpc.GetVersionResponse;
import org.janusgraph.graphdb.grpc.JanusGraphContextHandler;
import org.janusgraph.graphdb.grpc.JanusGraphManagerServiceGrpc;
import org.janusgraph.graphdb.grpc.types.JanusGraphContext;

public class JanusGraphManagerServiceImpl
extends JanusGraphManagerServiceGrpc.JanusGraphManagerServiceImplBase {
    private final JanusGraphContextHandler contextHandler;

    public JanusGraphManagerServiceImpl(JanusGraphContextHandler contextHandler) {
        this.contextHandler = contextHandler;
    }

    public void getJanusGraphContexts(GetJanusGraphContextsRequest request, StreamObserver<GetJanusGraphContextsResponse> responseObserver) {
        GetJanusGraphContextsResponse.Builder response = GetJanusGraphContextsResponse.newBuilder();
        for (JanusGraphContext context : this.contextHandler.getContexts()) {
            response.addContexts(context);
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getJanusGraphContextByGraphName(GetJanusGraphContextByGraphNameRequest request, StreamObserver<GetJanusGraphContextByGraphNameResponse> responseObserver) {
        String graphName = request.getGraphName();
        if (graphName.isEmpty()) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("graphName is required").asException());
            return;
        }
        JanusGraphContext context = this.contextHandler.getContextByGraphName(graphName);
        if (context == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("JanusGraphContext wasn't found for graphName").asException());
        }
        responseObserver.onNext((Object)GetJanusGraphContextByGraphNameResponse.newBuilder().setContext(context).build());
        responseObserver.onCompleted();
    }

    public void getVersion(GetVersionRequest request, StreamObserver<GetVersionResponse> responseObserver) {
        String tinkerPopVersion = "debug-tp";
        String janusGraphVersion = "debug-jg";
        if (Manifests.exists((String)"tinkerpopVersion")) {
            tinkerPopVersion = Manifests.read((String)"tinkerpopVersion");
        }
        if (Manifests.exists((String)"janusgraphVersion")) {
            janusGraphVersion = Manifests.read((String)"janusgraphVersion");
        }
        responseObserver.onNext((Object)GetVersionResponse.newBuilder().setTinkerpopVersion(tinkerPopVersion).setJanusgraphVersion(janusGraphVersion).build());
        responseObserver.onCompleted();
    }
}

