/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.rest.RestClientSetup;
import org.janusgraph.util.system.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ElasticSearchSetup {
    REST_CLIENT{

        @Override
        public Connection connect(Configuration config) throws IOException {
            return new Connection(new RestClientSetup().connect(config));
        }
    };

    private static final Logger log;

    static Map<String, Object> getSettingsFromJanusGraphConf(Configuration config) {
        Map settings = ConfigurationUtil.getSettingsFromJanusGraphConf((Configuration)config, (ConfigNamespace)ElasticSearchIndex.ES_CREATE_EXTRAS_NS);
        if (log.isDebugEnabled()) {
            settings.forEach((key, val) -> log.debug("[ES ext.* cfg] Set {}: {}", key, val));
            log.debug("Loaded {} settings from the {} JanusGraph config namespace", (Object)settings.size(), (Object)ElasticSearchIndex.ES_CREATE_EXTRAS_NS);
        }
        return new HashMap<String, Object>(settings);
    }

    public abstract Connection connect(Configuration var1) throws IOException;

    static {
        log = LoggerFactory.getLogger(ElasticSearchSetup.class);
    }

    public static class Connection {
        private final ElasticSearchClient client;

        public Connection(ElasticSearchClient client) {
            this.client = (ElasticSearchClient)Preconditions.checkNotNull((Object)client, (Object)"Unable to instantiate Elasticsearch Client object");
        }

        public ElasticSearchClient getClient() {
            return this.client;
        }
    }
}

