/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.AbstractTraverser;
import org.reflections8.Reflections;
import org.reflections8.scanners.Scanner;

public class JanusGraphTraverserUtil {
    private static final Set<Class<?>> TRAVERSERS_WITH_LOOP_SUPPORT = new HashSet();
    private static final Set<Class<?>> TRAVERSERS_WITHOUT_LOOP_SUPPORT = new HashSet();

    private static void addTraverserClass(Class<?> traverserType) {
        try {
            Class<?> declaredMethodClass = traverserType.getMethod("loops", new Class[0]).getDeclaringClass();
            if (JanusGraphTraverserUtil.isLoopsPotentiallySupported(declaredMethodClass)) {
                TRAVERSERS_WITH_LOOP_SUPPORT.add(traverserType);
            } else {
                TRAVERSERS_WITHOUT_LOOP_SUPPORT.add(traverserType);
            }
        }
        catch (NoSuchMethodException e) {
            TRAVERSERS_WITHOUT_LOOP_SUPPORT.add(traverserType);
        }
    }

    private static boolean isLoopsPotentiallySupported(Class<?> type) {
        return !type.equals(AbstractTraverser.class) && !type.equals(Traverser.class);
    }

    public static int getLoops(Traverser<?> traverser) {
        if (TRAVERSERS_WITH_LOOP_SUPPORT.contains(traverser.getClass())) {
            try {
                return traverser.loops();
            }
            catch (Exception exception) {
            }
        } else if (!TRAVERSERS_WITHOUT_LOOP_SUPPORT.contains(traverser.getClass())) {
            JanusGraphTraverserUtil.addTraverserClass(traverser.getClass());
            return JanusGraphTraverserUtil.getLoops(traverser);
        }
        return 0;
    }

    static {
        for (String packageToScan : Arrays.asList("org.apache.tinkerpop", "org.janusgraph")) {
            Reflections reflections = new Reflections(packageToScan, new Scanner[0]);
            Set subTypesOfTraverser = reflections.getSubTypesOf(Traverser.class);
            for (Class traverserType : subTypesOfTraverser) {
                JanusGraphTraverserUtil.addTraverserClass(traverserType);
            }
        }
    }
}

