/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.system;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Token;
import org.janusgraph.graphdb.types.TypeUtil;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.graphdb.types.system.SystemRelationType;

public abstract class SystemTypeManager {
    private static final Map<Long, SystemRelationType> SYSTEM_TYPES_BY_ID;
    private static final Map<String, SystemRelationType> SYSTEM_TYPES_BY_NAME;
    private static final Set<String> ADDITIONAL_RESERVED_NAMES;
    private static final char[] RESERVED_CHARS;

    public static SystemRelationType getSystemType(long id) {
        return SYSTEM_TYPES_BY_ID.get(id);
    }

    public static SystemRelationType getSystemType(String name) {
        return SYSTEM_TYPES_BY_NAME.get(name);
    }

    public static void throwIfSystemName(JanusGraphSchemaCategory category, String name) {
        TypeUtil.checkTypeName(category, name);
        if (SystemTypeManager.isSystemType(name.toLowerCase()) || Token.isSystemName(name)) {
            throw new IllegalArgumentException("Name cannot be in protected namespace: " + name);
        }
        for (char c : RESERVED_CHARS) {
            Preconditions.checkArgument((name.indexOf(c) < 0 ? 1 : 0) != 0, (String)"Name contains reserved character %s: %s", (char)c, (Object)name);
        }
    }

    public static boolean isSystemType(String name) {
        return SYSTEM_TYPES_BY_NAME.containsKey(name) || ADDITIONAL_RESERVED_NAMES.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        RESERVED_CHARS = new char[]{'{', '}', '\"', '\u001e'};
        Class<SystemTypeManager> clazz = SystemTypeManager.class;
        synchronized (SystemTypeManager.class) {
            SystemRelationType[] systemRelationTypes = new SystemRelationType[]{BaseKey.SchemaCategory, BaseKey.SchemaDefinitionDesc, BaseKey.SchemaDefinitionProperty, BaseKey.SchemaName, BaseKey.SchemaUpdateTime, BaseKey.VertexExists, BaseLabel.VertexLabelEdge, BaseLabel.SchemaDefinitionEdge, ImplicitKey.ID, ImplicitKey.JANUSGRAPHID, ImplicitKey.LABEL, ImplicitKey.KEY, ImplicitKey.VALUE, ImplicitKey.ADJACENT_ID, ImplicitKey.TIMESTAMP, ImplicitKey.TTL, ImplicitKey.VISIBILITY};
            HashMap<Long, SystemRelationType> idBuilder = new HashMap<Long, SystemRelationType>(systemRelationTypes.length);
            HashMap<String, SystemRelationType> nameBuilder = new HashMap<String, SystemRelationType>(systemRelationTypes.length);
            for (SystemRelationType et : systemRelationTypes) {
                idBuilder.put(et.longId(), et);
                nameBuilder.put(et.name(), et);
            }
            SYSTEM_TYPES_BY_ID = Collections.unmodifiableMap(idBuilder);
            SYSTEM_TYPES_BY_NAME = Collections.unmodifiableMap(nameBuilder);
            ADDITIONAL_RESERVED_NAMES = Collections.unmodifiableSet(Stream.of("key", "vertex", "edge", "element", "property", "label").collect(Collectors.toSet()));
            // ** MonitorExit[var0] (shouldn't be in output)
            assert (SYSTEM_TYPES_BY_ID.size() == 17);
            assert (SYSTEM_TYPES_BY_NAME.size() == 17);
            return;
        }
    }
}

