/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import java.util.Collection;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Connection;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.graphdb.internal.InternalVertexLabel;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeUtil;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.util.CollectionsUtil;

public class VertexLabelVertex
extends JanusGraphSchemaVertex
implements InternalVertexLabel {
    private Integer ttl = null;

    public VertexLabelVertex(StandardJanusGraphTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public boolean isPartitioned() {
        return this.getDefinition().getValue(TypeDefinitionCategory.PARTITIONED, Boolean.class);
    }

    @Override
    public boolean isStatic() {
        return this.getDefinition().getValue(TypeDefinitionCategory.STATIC, Boolean.class);
    }

    @Override
    public Collection<PropertyKey> mappedProperties() {
        return CollectionsUtil.toArrayList(this.getRelated(TypeDefinitionCategory.PROPERTY_KEY_EDGE, Direction.OUT), entry -> (PropertyKey)((Object)entry.getSchemaType()));
    }

    @Override
    public Collection<Connection> mappedConnections() {
        return CollectionsUtil.toArrayList(this.getRelated(TypeDefinitionCategory.CONNECTION_EDGE, Direction.OUT), entry -> new Connection((String)entry.getModifier(), this, (VertexLabel)((Object)entry.getSchemaType())));
    }

    @Override
    public boolean hasDefaultConfiguration() {
        return !this.isPartitioned() && !this.isStatic();
    }

    @Override
    public int getTTL() {
        if (null == this.ttl) {
            this.ttl = TypeUtil.getTTL(this);
        }
        return this.ttl;
    }
}

