/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.schema.Parameter;

public enum ParameterType {
    MAPPING("mapping"),
    INDEX_POSITION("index-pos"),
    MAPPED_NAME("mapped-name"),
    STATUS("status"),
    INDEX_GEO_MAX_LEVELS("index-geo-max-levels"),
    INDEX_GEO_DIST_ERROR_PCT("index-geo-dist-error-pct"),
    STRING_ANALYZER("string-analyzer"),
    TEXT_ANALYZER("text-analyzer");

    public static final String CUSTOM_PARAMETER_PREFIX = "%`custom%`";
    private final String name;

    private ParameterType(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name));
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public <V> V findParameter(Parameter[] parameters, V defaultValue) {
        V result = null;
        for (Parameter p : parameters) {
            if (!p.key().equalsIgnoreCase(this.name)) continue;
            Object value = p.value();
            Preconditions.checkNotNull(value, (String)"Invalid mapping specified: %s", value);
            Preconditions.checkArgument((result == null ? 1 : 0) != 0, (Object)"Multiple mappings specified");
            result = value;
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public boolean hasParameter(Parameter[] parameters) {
        return this.findParameter(parameters, null) != null;
    }

    public <V> Parameter<V> getParameter(V value) {
        return new Parameter<V>(this.name, value);
    }

    public static String customParameterName(String name) {
        return CUSTOM_PARAMETER_PREFIX + name;
    }

    public static List<Parameter> getCustomParameters(Parameter[] parameters) {
        return Arrays.stream(parameters).filter(p -> p.key().startsWith(CUSTOM_PARAMETER_PREFIX)).map(p -> new Parameter(p.key().substring(CUSTOM_PARAMETER_PREFIX.length()), p.value())).collect(Collectors.toList());
    }
}

