/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step.service;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphPropertiesStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.service.PropertiesFetchingService;

public class TraversalPropertiesFetchingService
implements PropertiesFetchingService {
    private final JanusGraphPropertiesStep propertiesStep;
    private final Traversal.Admin<Element, ? extends Property> propertyTraversal;

    public TraversalPropertiesFetchingService(Traversal.Admin<Element, ? extends Property> propertyTraversal, int batchSize, boolean prefetchAllPropertiesRequired) {
        this.propertyTraversal = propertyTraversal;
        Step step = propertyTraversal.getStartStep();
        while (step instanceof IdentityStep || step instanceof ProfileStep || step instanceof NoOpBarrierStep || step instanceof SideEffectStep) {
            step = step.getNextStep();
        }
        if (step instanceof PropertiesStep) {
            JanusGraphPropertiesStep propertiesStep;
            PropertiesStep originalStep = (PropertiesStep)step;
            if (originalStep instanceof JanusGraphPropertiesStep) {
                propertiesStep = (JanusGraphPropertiesStep)originalStep;
            } else {
                propertiesStep = new JanusGraphPropertiesStep(originalStep, prefetchAllPropertiesRequired, true);
                TraversalHelper.replaceStep((Step)originalStep, propertiesStep, (Traversal.Admin)originalStep.getTraversal());
            }
            propertiesStep.setUseMultiQuery(true);
            propertiesStep.setBatchSize(batchSize);
            this.propertiesStep = propertiesStep;
        } else {
            this.propertiesStep = null;
        }
    }

    @Override
    public Iterator<? extends Property> fetchProperties(Traverser.Admin<Element> traverser, Traversal.Admin<?, ?> traversal) {
        return TraversalUtil.applyAll(traverser, this.propertyTraversal);
    }

    @Override
    public void registerFirstNewLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.propertiesStep != null) {
            this.propertiesStep.registerFirstNewLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    @Override
    public void registerSameLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.propertiesStep != null) {
            this.propertiesStep.registerSameLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    @Override
    public void registerNextLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.propertiesStep != null) {
            this.propertiesStep.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    @Override
    public void setMetrics(MutableMetrics metrics) {
        if (this.propertiesStep != null) {
            this.propertiesStep.setMetrics(metrics);
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        if (this.propertiesStep != null) {
            this.propertiesStep.setBatchSize(batchSize);
        }
    }
}

