/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.FetchQueryBuildFunction;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.HasStepBatchFetcher;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.graphdb.util.CopyStepUtil;
import org.janusgraph.graphdb.util.JanusGraphTraverserUtil;

public class JanusGraphHasStep<S extends Element>
extends HasStep<S>
implements Profiling,
MultiQueriable<S, S> {
    private boolean useMultiQuery = false;
    private int txVertexCacheSize = 20000;
    private final Set<String> propertiesToFetch = new HashSet<String>();
    private final List<HasContainer> idHasContainers = new ArrayList<HasContainer>();
    private final List<HasContainer> labelHasContainers = new ArrayList<HasContainer>();
    private final List<HasContainer> propertyHasContainers = new ArrayList<HasContainer>();
    private boolean prefetchAllPropertiesRequired;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private int batchSize = Integer.MAX_VALUE;
    private HasStepBatchFetcher hasStepBatchFetcher;

    public JanusGraphHasStep(Traversal.Admin traversal, HasContainer ... hasContainers) {
        super(traversal, hasContainers);
        this.generatePrefetchRequirements();
    }

    public JanusGraphHasStep(HasStep<S> originalStep) {
        this(originalStep.getTraversal(), originalStep.getHasContainers().toArray(new HasContainer[0]));
        CopyStepUtil.copyAbstractStepModifiableFields(originalStep, this);
        if (originalStep instanceof JanusGraphHasStep) {
            JanusGraphHasStep originalJanusGraphHasStep = (JanusGraphHasStep)originalStep;
            this.txVertexCacheSize = originalJanusGraphHasStep.txVertexCacheSize;
            this.setBatchSize(originalJanusGraphHasStep.batchSize);
            this.setUseMultiQuery(originalJanusGraphHasStep.useMultiQuery);
        }
    }

    public void addHasContainer(HasContainer hasContainer) {
        super.addHasContainer(hasContainer);
        this.withPrefetch(hasContainer);
    }

    public void removeHasContainer(HasContainer hasContainer) {
        super.removeHasContainer(hasContainer);
        this.propertiesToFetch.clear();
        this.labelHasContainers.clear();
        this.idHasContainers.clear();
        this.propertyHasContainers.clear();
        this.generatePrefetchRequirements();
    }

    protected boolean filter(Traverser.Admin<S> traverser) {
        if (this.useMultiQuery && traverser.get() instanceof Vertex) {
            return (Boolean)this.hasStepBatchFetcher.fetchData(this.getTraversal(), (Vertex)traverser.get(), JanusGraphTraverserUtil.getLoops(traverser));
        }
        return super.filter(traverser);
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
        if (useMultiQuery && this.hasStepBatchFetcher == null) {
            this.hasStepBatchFetcher = new HasStepBatchFetcher(this.idHasContainers, this.labelHasContainers, this.propertyHasContainers, this.getFetcherBatchSize(), new FetchQueryBuildFunction(){

                @Override
                public <Q extends BaseVertexQuery> Q makeQuery(Q query) {
                    return BasicVertexCentricQueryUtil.withLabelVertices((BasicVertexCentricQueryBuilder)query).profiler(JanusGraphHasStep.this.queryProfiler);
                }
            }, new FetchQueryBuildFunction(){
                private String[] propertyKeys;

                @Override
                public <Q extends BaseVertexQuery> Q makeQuery(Q query) {
                    if (!JanusGraphHasStep.this.prefetchAllPropertiesRequired) {
                        if (this.propertyKeys == null) {
                            this.propertyKeys = JanusGraphHasStep.this.propertiesToFetch.toArray(new String[0]);
                        }
                        query.keys(this.propertyKeys);
                    }
                    return ((BasicVertexCentricQueryBuilder)query).profiler(JanusGraphHasStep.this.queryProfiler);
                }
            });
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.hasStepBatchFetcher != null) {
            this.hasStepBatchFetcher.setBatchSize(this.getFetcherBatchSize());
        }
    }

    @Override
    public void registerFirstNewLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.hasStepBatchFetcher.registerFirstNewLoopFutureVertexForPrefetching(futureVertex);
        }
    }

    @Override
    public void registerSameLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.hasStepBatchFetcher.registerCurrentLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    @Override
    public void registerNextLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.hasStepBatchFetcher.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }

    public void setTxVertexCacheSize(int txVertexCacheSize) {
        this.txVertexCacheSize = txVertexCacheSize;
        if (this.hasStepBatchFetcher != null) {
            this.hasStepBatchFetcher.setBatchSize(this.getFetcherBatchSize());
        }
    }

    private void generatePrefetchRequirements() {
        for (HasContainer condition : this.getHasContainers()) {
            this.withPrefetch(condition);
        }
    }

    private void withPrefetch(HasContainer condition) {
        if (ImplicitKey.ID.name().equals(condition.getKey())) {
            this.idHasContainers.add(condition);
        } else if (ImplicitKey.LABEL.name().equals(condition.getKey())) {
            this.labelHasContainers.add(condition);
        } else {
            this.propertyHasContainers.add(condition);
            this.propertiesToFetch.add(condition.getKey());
        }
    }

    public void withPropertyPrefetch(String key) {
        this.propertiesToFetch.add(key);
    }

    public boolean isPrefetchAllPropertiesRequired() {
        return this.prefetchAllPropertiesRequired;
    }

    public void setPrefetchAllPropertiesRequired(boolean prefetchAllPropertiesRequired) {
        this.prefetchAllPropertiesRequired = prefetchAllPropertiesRequired;
    }

    private int getFetcherBatchSize() {
        return Math.min(this.batchSize, this.txVertexCacheSize);
    }
}

