/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DropStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventCallback;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventUtil;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.DropStepBatchFetcher;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.util.CopyStepUtil;
import org.janusgraph.graphdb.util.JanusGraphTraverserUtil;

public class JanusGraphDropStep<S extends Element>
extends DropStep<S>
implements Profiling,
MultiQueriable<S, S> {
    private boolean useMultiQuery = false;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private int batchSize = Integer.MAX_VALUE;
    private DropStepBatchFetcher dropStepBatchFetcher;

    public JanusGraphDropStep(DropStep<S> originalStep) {
        super(originalStep.getTraversal());
        CopyStepUtil.copyAbstractStepModifiableFields(originalStep, this);
        CallbackRegistry callbackRegistry = this.getMutatingCallbackRegistry();
        for (EventCallback callback : originalStep.getMutatingCallbackRegistry().getCallbacks()) {
            callbackRegistry.addCallback(callback);
        }
        if (originalStep instanceof JanusGraphDropStep) {
            JanusGraphDropStep originalJanusGraphLabelStep = (JanusGraphDropStep)originalStep;
            this.setBatchSize(originalJanusGraphLabelStep.batchSize);
            this.setUseMultiQuery(originalJanusGraphLabelStep.useMultiQuery);
        }
    }

    protected boolean filter(Traverser.Admin<S> traverser) {
        if (this.useMultiQuery && traverser.get() instanceof Vertex) {
            this.dropStepBatchFetcher.fetchData(this.getTraversal(), (Vertex)traverser.get(), JanusGraphTraverserUtil.getLoops(traverser));
            return false;
        }
        return super.filter(traverser);
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
        if (this.useMultiQuery && this.dropStepBatchFetcher == null) {
            this.dropStepBatchFetcher = new DropStepBatchFetcher(this::makeLabelsQuery, this.batchSize, (batchVertices, requiredVertex) -> {
                List callbacksForRemovalEvents = this.getMutatingCallbackRegistry().getCallbacks();
                if (!callbacksForRemovalEvents.isEmpty()) {
                    EventStrategy eventStrategy = EventUtil.forceGetEventStrategy((Traversal.Admin)this.traversal);
                    JanusGraphDropStep.produceRemovedEvent(eventStrategy, callbacksForRemovalEvents, requiredVertex);
                    for (Vertex vertexInBatch : batchVertices) {
                        if (vertexInBatch == requiredVertex) continue;
                        JanusGraphDropStep.produceRemovedEvent(eventStrategy, callbacksForRemovalEvents, vertexInBatch);
                    }
                }
            });
        }
    }

    private static void produceRemovedEvent(EventStrategy eventStrategy, List<EventCallback<Event>> callbacksForRemovalEvents, Vertex vertex) {
        Event.VertexRemovedEvent removeEvent = new Event.VertexRemovedEvent((Vertex)eventStrategy.detach((Object)vertex));
        for (EventCallback<Event> callback : callbacksForRemovalEvents) {
            callback.accept((Object)removeEvent);
        }
    }

    private <Q extends BaseVertexQuery> Q makeLabelsQuery(Q query) {
        ((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
        return query;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.dropStepBatchFetcher != null) {
            this.dropStepBatchFetcher.setBatchSize(batchSize);
        }
    }

    @Override
    public void registerFirstNewLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.dropStepBatchFetcher.registerFirstNewLoopFutureVertexForPrefetching(futureVertex);
        }
    }

    @Override
    public void registerSameLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.dropStepBatchFetcher.registerCurrentLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    @Override
    public void registerNextLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.dropStepBatchFetcher.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

