/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.EntryArrayList;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexWithInlineProps {
    private final Object vertexId;
    private final Map<SliceQuery, EntryList> inlineProperties;
    private static final Logger log = LoggerFactory.getLogger(VertexWithInlineProps.class);

    public VertexWithInlineProps(Object vertexId, EntryList inlineProperties, Map<String, SliceQuery> inlineQueries, StandardJanusGraphTx tx) {
        this.vertexId = vertexId;
        this.inlineProperties = this.loadInlineProperties(inlineProperties, inlineQueries, tx);
    }

    public Object getVertexId() {
        return this.vertexId;
    }

    public Map<SliceQuery, EntryList> getInlineProperties() {
        return this.inlineProperties;
    }

    private Map<SliceQuery, EntryList> loadInlineProperties(EntryList inlineProperties, Map<String, SliceQuery> inlineQueries, StandardJanusGraphTx tx) {
        if (inlineProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<SliceQuery, EntryList> result = new HashMap<SliceQuery, EntryList>();
        for (Entry dataEntry : inlineProperties) {
            long typeId = tx.getEdgeSerializer().parseTypeId(dataEntry);
            InternalRelationType type = tx.getOrLoadRelationTypeById(typeId);
            assert (type.isPropertyKey());
            SliceQuery sq = inlineQueries.get(type.name());
            if (sq != null) {
                if (result.containsKey(sq)) {
                    ((EntryList)result.get(sq)).add(dataEntry);
                    continue;
                }
                EntryArrayList entryList = new EntryArrayList();
                entryList.add(dataEntry);
                result.put(sq, entryList);
                continue;
            }
            log.error("Missing key=" + type.name() + " in inlineQueries. Check index definition.");
        }
        return result;
    }

    public int hashCode() {
        return this.vertexId.hashCode();
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (this.getClass().isInstance(oth)) {
            return this.vertexId.equals(((VertexWithInlineProps)oth).vertexId);
        }
        return this.vertexId.equals(oth);
    }
}

