/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.BaseQuery;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.FixedCondition;
import org.janusgraph.graphdb.query.profile.ProfileObservable;
import org.janusgraph.graphdb.query.profile.QueryProfiler;

public class BaseVertexCentricQuery
extends BaseQuery
implements ProfileObservable {
    protected final Condition<JanusGraphRelation> condition;
    protected final List<BackendQueryHolder<SliceQuery>> queries;
    private final OrderList orders;
    protected final Direction direction;
    private QueryProfiler profiler = QueryProfiler.NO_OP;

    public BaseVertexCentricQuery(Condition<JanusGraphRelation> condition, Direction direction, List<BackendQueryHolder<SliceQuery>> queries, OrderList orders, int limit) {
        super(limit);
        Preconditions.checkArgument((condition != null && queries != null && direction != null ? 1 : 0) != 0);
        this.condition = condition;
        this.queries = queries;
        this.orders = orders;
        this.direction = direction;
    }

    protected BaseVertexCentricQuery(BaseVertexCentricQuery query) {
        this(query.getCondition(), query.getDirection(), query.getQueries(), query.getOrders(), query.getLimit());
    }

    protected BaseVertexCentricQuery() {
        this(new FixedCondition<JanusGraphRelation>(false), Direction.BOTH, new ArrayList<BackendQueryHolder<SliceQuery>>(0), OrderList.NO_ORDER, 0);
    }

    public static BaseVertexCentricQuery emptyQuery() {
        return new BaseVertexCentricQuery();
    }

    public Condition<JanusGraphRelation> getCondition() {
        return this.condition;
    }

    public OrderList getOrders() {
        return this.orders;
    }

    public Direction getDirection() {
        return this.direction;
    }

    protected List<BackendQueryHolder<SliceQuery>> getQueries() {
        return this.queries;
    }

    public boolean isEmpty() {
        return this.getLimit() <= 0;
    }

    public int numSubQueries() {
        return this.queries.size();
    }

    public boolean isSimple() {
        return this.queries.size() == 1 && this.queries.get(0).isFitted() && this.queries.get(0).isSorted();
    }

    public BackendQueryHolder<SliceQuery> getSubQuery(int position) {
        return this.queries.get(position);
    }

    public boolean matches(JanusGraphRelation relation) {
        return this.condition.evaluate(relation);
    }

    public String toString() {
        String s = "[" + this.condition.toString() + "]";
        if (this.hasLimit()) {
            s = s + ":" + this.getLimit();
        }
        return s;
    }

    @Override
    public void observeWith(QueryProfiler profiler, boolean hasSiblings) {
        this.profiler = profiler;
        profiler.setAnnotation("condition", this.condition);
        profiler.setAnnotation("orders", this.orders);
        if (this.hasLimit()) {
            profiler.setAnnotation("limit", this.getLimit());
        }
        boolean consistsOfMultipleQueries = this.queries.size() > 1;
        this.queries.forEach(bqh -> bqh.observeWith(profiler, consistsOfMultipleQueries));
    }

    @Override
    public QueryProfiler getProfiler() {
        return this.profiler;
    }
}

