/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import java.util.Objects;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphLazyEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.graphdb.query.condition.Literal;
import org.janusgraph.graphdb.relations.CacheEdge;

public class DirectionCondition<E extends JanusGraphRelation>
extends Literal<E> {
    private final JanusGraphVertex baseVertex;
    private final Direction direction;

    public DirectionCondition(JanusGraphVertex vertex, Direction dir) {
        assert (vertex != null && dir != null);
        this.baseVertex = vertex;
        this.direction = dir;
    }

    @Override
    public boolean evaluate(E element) {
        if (this.direction == Direction.BOTH) {
            return true;
        }
        if (element instanceof JanusGraphLazyEdge) {
            element = ((JanusGraphLazyEdge)element).loadValue();
        }
        if (element instanceof CacheEdge) {
            return this.direction == ((CacheEdge)element).getVertexCentricDirection();
        }
        if (element instanceof JanusGraphEdge) {
            return ((JanusGraphEdge)element).vertex(this.direction).equals(this.baseVertex);
        }
        if (element instanceof JanusGraphVertexProperty) {
            return this.direction == Direction.OUT;
        }
        return false;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.direction, this.baseVertex});
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        DirectionCondition oth = (DirectionCondition)other;
        return this.direction == oth.direction && this.baseVertex.equals(oth.baseVertex);
    }

    @Override
    public String toString() {
        return "dir[" + this.getDirection() + "]";
    }
}

