/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import com.carrotsearch.hppc.ObjectArrayList;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;

public class VertexState<M> {
    protected Object properties;
    private Object previousMessages;
    private Object currentMessages;
    static final VertexState EMPTY_STATE = new EmptyState();

    private VertexState() {
        this.properties = null;
        this.previousMessages = null;
        this.currentMessages = null;
    }

    public VertexState(Map<String, Integer> keyMap) {
        assert (VertexState.isValidIdMap(keyMap));
        this.previousMessages = null;
        this.currentMessages = null;
        this.properties = keyMap.isEmpty() || keyMap.size() == 1 ? null : new Object[keyMap.size()];
    }

    public <V> void setProperty(String key, V value, Map<String, Integer> keyMap) {
        assert (!keyMap.isEmpty() && keyMap.containsKey(key));
        if (keyMap.size() == 1) {
            this.properties = value;
        } else {
            ((Object[])this.properties)[keyMap.get((Object)key).intValue()] = value;
        }
    }

    public <V> V getProperty(String key, Map<String, Integer> keyMap) {
        assert (!keyMap.isEmpty() && keyMap.containsKey(key));
        if (keyMap.size() == 1) {
            return (V)this.properties;
        }
        return (V)((Object[])this.properties)[keyMap.get(key)];
    }

    private void initializeCurrentMessages(Map<MessageScope, Integer> scopeMap) {
        assert (!scopeMap.isEmpty() && VertexState.isValidIdMap(scopeMap));
        if (this.currentMessages == null && scopeMap.size() > 1) {
            this.currentMessages = new Object[scopeMap.size()];
        }
    }

    public synchronized void setMessage(M message, MessageScope scope, Map<MessageScope, Integer> scopeMap) {
        assert (message != null && scope != null);
        Preconditions.checkArgument((boolean)scopeMap.containsKey(scope), (String)"Provided scope was not declared in the VertexProgram: %s", (Object)scope);
        this.initializeCurrentMessages(scopeMap);
        if (scopeMap.size() == 1) {
            this.currentMessages = message;
        } else {
            ((Object[])this.currentMessages)[scopeMap.get((Object)scope).intValue()] = message;
        }
    }

    public synchronized void addMessage(M message, MessageScope scope, Map<MessageScope, Integer> scopeMap, MessageCombiner<M> combiner) {
        assert (message != null && scope != null);
        Preconditions.checkArgument((boolean)scopeMap.containsKey(scope), (String)"Provided scope was not declared in the VertexProgram: %s", (Object)scope);
        this.initializeCurrentMessages(scopeMap);
        if (scopeMap.size() == 1) {
            this.currentMessages = this.currentMessages == null ? message : this.combineMessages(combiner, message, this.currentMessages);
        } else {
            Object[] messages = (Object[])this.currentMessages;
            int pos = scopeMap.get(scope);
            Object object = messages[pos] == null ? message : this.combineMessages(combiner, message, messages[pos]);
            messages[pos] = object;
        }
    }

    private Object combineMessages(MessageCombiner<M> combiner, M messageA, Object messageB) {
        Object combinedMessage;
        if (combiner != null) {
            combinedMessage = combiner.combine(messageA, messageB);
        } else if (messageB instanceof ObjectArrayList) {
            ((ObjectArrayList)messageB).add(messageA);
            combinedMessage = messageB;
        } else {
            ObjectArrayList arrayList = new ObjectArrayList();
            arrayList.add(messageA, messageB);
            combinedMessage = arrayList;
        }
        return combinedMessage;
    }

    public Stream<M> getMessage(MessageScope scope, Map<MessageScope, Integer> scopeMap) {
        assert (scope != null && VertexState.isValidIdMap(scopeMap) && scopeMap.containsKey(scope));
        Object message = scopeMap.size() == 1 ? this.previousMessages : (this.previousMessages != null ? ((Object[])this.previousMessages)[scopeMap.get(scope)] : null);
        if (message instanceof ObjectArrayList) {
            Iterator transform = Iterators.transform((Iterator)((ObjectArrayList)message).iterator(), e -> e.value);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(transform, 1088), false);
        }
        return message == null ? Stream.empty() : Stream.of(message);
    }

    public synchronized void completeIteration() {
        this.previousMessages = this.currentMessages;
        this.currentMessages = null;
    }

    public static boolean isValidIdMap(Map<?, Integer> map) {
        if (map == null) {
            return false;
        }
        if (map.isEmpty()) {
            return true;
        }
        int size = map.size();
        HashSet<Integer> ids = new HashSet<Integer>(size);
        for (Integer id : map.values()) {
            if (id >= size || id < 0) {
                return false;
            }
            if (ids.add(id)) continue;
            return false;
        }
        return true;
    }

    private static class EmptyState<M>
    extends VertexState<M> {
        private EmptyState() {
        }

        @Override
        public <V> void setProperty(String key, V value, Map<String, Integer> keyMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> V getProperty(String key, Map<String, Integer> keyMap) {
            return null;
        }

        @Override
        public Stream<M> getMessage(MessageScope scope, Map<MessageScope, Integer> scopeMap) {
            return Stream.empty();
        }

        @Override
        public synchronized void setMessage(M message, MessageScope scope, Map<MessageScope, Integer> scopeMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void addMessage(M message, MessageScope scope, Map<MessageScope, Integer> scopeMap, MessageCombiner<M> combiner) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void completeIteration() {
            throw new UnsupportedOperationException();
        }
    }
}

