/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.graphdb.olap.computer.FulgoraElementTraversal;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphVertexStep;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphLocalQueryOptimizerStrategy;

public class FulgoraUtil {
    private static final TraversalStrategies FULGORA_STRATEGIES = TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{JanusGraphLocalQueryOptimizerStrategy.instance()});

    public static JanusGraphVertexStep<Vertex> getReverseJanusGraphVertexStep(MessageScope.Local<?> scope, JanusGraphTransaction graph) {
        FulgoraElementTraversal<Vertex, Edge> result = FulgoraUtil.getReverseTraversal(scope, graph, null);
        result.asAdmin().applyStrategies();
        FulgoraUtil.verifyIncidentTraversal(result);
        return (JanusGraphVertexStep)result.getStartStep();
    }

    public static Traversal<Vertex, Edge> getReverseElementTraversal(MessageScope.Local<?> scope, Vertex start, JanusGraphTransaction graph) {
        return FulgoraUtil.getReverseTraversal(scope, graph, start);
    }

    private static FulgoraElementTraversal<Vertex, Edge> getReverseTraversal(MessageScope.Local<?> scope, JanusGraphTransaction graph, @Nullable Vertex start) {
        Traversal.Admin incident = ((Traversal)scope.getIncidentTraversal().get()).asAdmin();
        FulgoraElementTraversal<Vertex, Edge> result = FulgoraElementTraversal.of(graph);
        for (Step step : incident.getSteps()) {
            result.addStep(step);
        }
        Step startStep = result.getStartStep();
        assert (startStep instanceof VertexStep);
        ((VertexStep)startStep).reverseDirection();
        if (start != null) {
            result.addStep(0, (Step)new StartStep(incident, (Object)start));
        }
        result.asAdmin().setStrategies(FULGORA_STRATEGIES);
        return result;
    }

    private static void verifyIncidentTraversal(FulgoraElementTraversal<Vertex, Edge> traversal) {
        List steps = traversal.getSteps();
        Step startStep = (Step)steps.get(0);
        Preconditions.checkArgument((startStep instanceof JanusGraphVertexStep && JanusGraphTraversalUtil.isEdgeReturnStep((JanusGraphVertexStep)startStep) ? 1 : 0) != 0, (String)"Expected first step to be an edge step but found: %s", (Object)startStep);
        Optional<Step> violatingStep = steps.stream().filter(s -> !(s instanceof JanusGraphVertexStep) && !(s instanceof OrderGlobalStep) && !(s instanceof OrderLocalStep) && !(s instanceof IdentityStep) && !(s instanceof FilterStep)).findAny();
        violatingStep.ifPresent(step -> {
            throw new IllegalArgumentException("Encountered unsupported step in incident traversal: " + step);
        });
    }
}

