/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.internal;

import java.util.Collections;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.graphdb.query.condition.Condition;

public enum RelationCategory implements Condition<JanusGraphRelation>
{
    EDGE,
    PROPERTY,
    RELATION;


    public boolean isProper() {
        switch (this) {
            case EDGE: 
            case PROPERTY: {
                return true;
            }
            case RELATION: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unrecognized type: " + this));
    }

    public Iterable<JanusGraphRelation> executeQuery(JanusGraphVertexQuery query) {
        switch (this) {
            case EDGE: {
                return query.edges();
            }
            case PROPERTY: {
                return query.properties();
            }
            case RELATION: {
                return query.relations();
            }
        }
        throw new AssertionError();
    }

    @Override
    public Condition.Type getType() {
        return Condition.Type.LITERAL;
    }

    @Override
    public Iterable getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public int numChildren() {
        return 0;
    }

    @Override
    public boolean evaluate(JanusGraphRelation relation) {
        switch (this) {
            case EDGE: {
                return relation.isEdge();
            }
            case PROPERTY: {
                return relation.isProperty();
            }
            case RELATION: {
                return true;
            }
        }
        throw new AssertionError((Object)("Unrecognized type: " + this));
    }
}

