/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.internal;

import java.util.Objects;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.ElementLifeCycle;
import org.janusgraph.graphdb.internal.InternalElement;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.util.IDUtils;

public abstract class AbstractElement
implements InternalElement,
Comparable<JanusGraphElement> {
    private Object id;

    public AbstractElement(Object id) {
        this.id = id;
    }

    public static boolean isTemporaryId(Object elementId) {
        return elementId instanceof Number && ((Number)elementId).longValue() < 0L;
    }

    public int hashCode() {
        return Objects.hashCode(this.getCompareId());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(this instanceof Vertex && other instanceof Vertex || this instanceof Edge && other instanceof Edge || this instanceof VertexProperty && other instanceof VertexProperty)) {
            return false;
        }
        if (other instanceof AbstractElement) {
            return Objects.equals(this.getCompareId(), ((AbstractElement)other).getCompareId());
        }
        if (other instanceof JanusGraphElement) {
            return ((JanusGraphElement)other).hasId() && Objects.equals(this.getCompareId(), ((JanusGraphElement)other).id());
        }
        Object otherId = ((Element)other).id();
        if (otherId instanceof RelationIdentifier) {
            return Objects.equals(((RelationIdentifier)otherId).getRelationId(), this.getCompareId());
        }
        return otherId.equals(this.getCompareId());
    }

    @Override
    public int compareTo(JanusGraphElement other) {
        return AbstractElement.compare(this, other);
    }

    public static int compare(JanusGraphElement e1, JanusGraphElement e2) {
        Object e1id = e1 instanceof InternalElement ? ((InternalElement)e1).getCompareId() : e1.id();
        Object e2id = e2 instanceof InternalElement ? ((InternalElement)e2).getCompareId() : e2.id();
        return IDUtils.compare((Object)e1id, (Object)e2id);
    }

    public InternalVertex clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public Object getCompareId() {
        return this.id();
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return !AbstractElement.isTemporaryId(this.id);
    }

    @Override
    public void setId(Object id) {
        assert (!AbstractElement.isTemporaryId(id));
        this.id = id;
    }

    @Override
    public boolean isInvisible() {
        return IDManager.VertexIDType.Invisible.is(this.id);
    }

    @Override
    public boolean isNew() {
        return ElementLifeCycle.isNew(this.it().getLifeCycle());
    }

    @Override
    public boolean isLoaded() {
        return ElementLifeCycle.isLoaded(this.it().getLifeCycle());
    }

    @Override
    public boolean isRemoved() {
        return ElementLifeCycle.isRemoved(this.it().getLifeCycle());
    }
}

