/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.cache;

import java.util.Collections;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.graphdb.database.cache.CacheInvalidationService;
import org.janusgraph.graphdb.idmanagement.IDManager;

public class KCVSCacheInvalidationService
implements CacheInvalidationService {
    private final KCVSCache edgeStore;
    private final KCVSCache indexStore;
    private final IDManager idManager;

    public KCVSCacheInvalidationService(KCVSCache edgeStore, KCVSCache indexStore, IDManager idManager) {
        this.edgeStore = edgeStore;
        this.indexStore = indexStore;
        this.idManager = idManager;
    }

    @Override
    public void markVertexAsExpiredInEdgeStore(Object vertexId) {
        StaticBuffer vertexIdKey = this.idManager.getKey(vertexId);
        this.markKeyAsExpiredInEdgeStore(vertexIdKey);
    }

    @Override
    public void markKeyAsExpiredInEdgeStore(StaticBuffer key) {
        this.edgeStore.invalidate(key, Collections.emptyList());
    }

    @Override
    public void markKeyAsExpiredInIndexStore(StaticBuffer key) {
        this.indexStore.invalidate(key, Collections.emptyList());
    }

    @Override
    public void forceClearExpiredKeysInEdgeStoreCache() {
        this.edgeStore.forceClearExpiredCache();
    }

    @Override
    public void forceClearExpiredKeysInIndexStoreCache() {
        this.indexStore.forceClearExpiredCache();
    }

    @Override
    public void forceInvalidateVertexInEdgeStoreCache(Object vertexId) {
        this.markVertexAsExpiredInEdgeStore(vertexId);
        this.forceClearExpiredKeysInEdgeStoreCache();
    }

    @Override
    public void forceInvalidateVerticesInEdgeStoreCache(Iterable<Object> vertexIds) {
        for (Object vertexId : vertexIds) {
            this.markVertexAsExpiredInEdgeStore(vertexId);
        }
        this.forceClearExpiredKeysInEdgeStoreCache();
    }

    @Override
    public void clearEdgeStoreCache() {
        this.edgeStore.clearCache();
    }

    @Override
    public void clearIndexStoreCache() {
        this.indexStore.clearCache();
    }

    @Override
    public void clearDBCache() {
        this.clearEdgeStoreCache();
        this.clearIndexStoreCache();
    }
}

