/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.EnumMap;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.RelationCategory;

public class RelationQueryCache
implements AutoCloseable {
    private final Cache<Long, CacheEntry> cache;
    private final EdgeSerializer edgeSerializer;
    private final EnumMap<RelationCategory, SliceQuery> relationTypes;

    public RelationQueryCache(EdgeSerializer edgeSerializer) {
        this(edgeSerializer, 256);
    }

    public RelationQueryCache(EdgeSerializer edgeSerializer, int capacity) {
        this.edgeSerializer = edgeSerializer;
        this.cache = Caffeine.newBuilder().maximumSize((long)(capacity * 3 / 2)).initialCapacity(capacity).build();
        this.relationTypes = new EnumMap(RelationCategory.class);
        for (RelationCategory rt : RelationCategory.values()) {
            this.relationTypes.put(rt, edgeSerializer.getQuery(rt, false));
        }
    }

    public SliceQuery getQuery(RelationCategory type) {
        return this.relationTypes.get(type);
    }

    public SliceQuery getQuery(InternalRelationType type, Direction dir) {
        CacheEntry ce = (CacheEntry)this.cache.get((Object)type.longId(), key -> new CacheEntry(this.edgeSerializer, type));
        assert (ce != null);
        return ce.get(dir);
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static final class CacheEntry {
        private final SliceQuery in;
        private final SliceQuery out;
        private final SliceQuery both;

        public CacheEntry(EdgeSerializer edgeSerializer, InternalRelationType t) {
            if (t.isPropertyKey()) {
                this.in = this.out = edgeSerializer.getQuery(t, Direction.OUT, new EdgeSerializer.TypedInterval[t.getSortKey().length]);
                this.both = this.out;
            } else {
                this.out = edgeSerializer.getQuery(t, Direction.OUT, new EdgeSerializer.TypedInterval[t.getSortKey().length]);
                this.in = edgeSerializer.getQuery(t, Direction.IN, new EdgeSerializer.TypedInterval[t.getSortKey().length]);
                this.both = edgeSerializer.getQuery(t, Direction.BOTH, new EdgeSerializer.TypedInterval[t.getSortKey().length]);
            }
        }

        public SliceQuery get(Direction dir) {
            switch (dir) {
                case IN: {
                    return this.in;
                }
                case OUT: {
                    return this.out;
                }
                case BOTH: {
                    return this.both;
                }
            }
            throw new AssertionError((Object)("Unknown direction: " + dir));
        }
    }
}

